package com.xforceplus.oqsengine.sdk.reexploit.spring;

import com.xforceplus.oqsengine.sdk.reexploit.spring.annotation.OqsEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.model.BaseEntity;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.*;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.util.CompletableFutureUtils;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import io.vavr.control.Either;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.*;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.xforceplus.ultraman.oqsengine.sdk.utils.PropertyHelperEx.getColumnName;

@Repository
public class SimpleEntityRepository<T> implements EntityRepository<T> {

    private OqsEntityInformation entityInformation;

    private RepositoryInformation repositoryInformation;

    private ContextService contextService;

    private EntityFacade entityFacade;

    private OqsMappingContext context;

    private ProfileFetcher profileFetcher;

    private String code;

    private Logger logger = LoggerFactory.getLogger(SimpleEntityRepository.class);

    private static final String ENTITY_NOT_FOUND = "OqsEntity Not Found";

    public SimpleEntityRepository(OqsEntityInformation<T, Long> entityInformation,
                                  RepositoryInformation repositoryInformation,
                                  OqsMappingContext context,
                                  EntityFacade entityFacade,
                                  ProfileFetcher profileFetcher) {
        Assert.notNull(entityInformation, "OqsEntityInformation must not be null.");
        this.entityInformation = entityInformation;
        this.repositoryInformation = repositoryInformation;
        this.entityFacade = entityFacade;
        this.contextService = context.getContextService();
        this.context = context;
        this.profileFetcher = profileFetcher;

        OqsEntity annotation = entityInformation.getJavaType().getAnnotation(OqsEntity.class);

        if (annotation != null) {
            this.code = annotation.value();
        }
    }

    private <T> T get(CompletionStage<T> future) {
        return future.toCompletableFuture().join();
    }

    private void setRecord(Class javaType, Object o, Record record) {
        Field[] allFields = FieldUtils.getAllFields(javaType);
        Optional<Field> record2 = Arrays.stream(allFields)
                .filter(field -> field.getName().equalsIgnoreCase("record"))
                .findFirst();

        record2.ifPresent(recordField -> {
            try {
                recordField.setAccessible(true);
                recordField.set(o, record);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /**
     * TODO
     * side-effect
     *
     * @return
     */
    private void appendSort(ExpSort expSort, Sort sort) {
        sort.stream().forEach(x -> {
            expSort.withSort(x.getProperty(), x.isAscending() ? "asc" : "desc");
        });
    }

    private void appendPage(ExpQuery expQuery, Pageable pageable) {
        expQuery.range(pageable.getPageNumber(), pageable.getPageSize());
    }

    private Iterable<T> findIterable(ExpRel expQuery, Sort sort) {

        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);

        IEntityClass iEntityClass = persistentEntity.getSchema();
        IEntityClassGroup reader = entityFacade.getReader(iEntityClass, contextService.getAll());

        ExpSort expSort = ExpSort.init();
        //TODO
        if (sort != null && sort.isSorted()) {
            appendSort(expSort, sort);
        }
        ExpRel expRel = ExpFactory.withSort(expQuery, expSort);

        Iterable<T> recordsIterator = entityFacade
                .queryIterate(iEntityClass, expRel,
                        record -> {
                            try {
                                Object o = javaType.newInstance();
                                setRecord(javaType, o, record);
                                return (T) o;
                            } catch (InstantiationException | IllegalAccessException e) {
                                e.printStackTrace();
                                return null;
                            }
                        },
                        context.getExecutionConfig().getLegacy(),
                        getContext()
                );

        return recordsIterator;
    }

    private Page<T> findAllInner(ExpQuery expQuery, Pageable pageable, Sort sort) {
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);

        IEntityClass iEntityClass = persistentEntity.getSchema();
        IEntityClassGroup reader = entityFacade.getReader(iEntityClass, contextService.getAll());

        ExpContext expContext = new ExpContext()
                .withContext(Optional.ofNullable(contextService).map(ContextService::getAll)
                        .orElse(Collections.emptyMap()))
                .setSchema(reader);

        if (pageable != null && pageable.isPaged()) {
            expQuery.range(pageable.getPageNumber(), pageable.getPageSize());
        }

        ExpSort expSort = ExpSort.init();
        //TODO
        if (sort != null && sort.isSorted()) {
            appendSort(expSort, sort);
        }
        expQuery.sort(expSort);

        Either<QueryResult, DataCollection<Record>> query = get(
                entityFacade.query(expContext,
                        expQuery ));

        AtomicLong total = new AtomicLong(0);
        List<T> list = query.map(x -> {

            total.set(x.getRowNum());
            return x.getRows().stream().map(record -> {
                try {
                    Object o = javaType.newInstance();
                    setRecord(javaType, o, record);
                    return (T) o;
                } catch (InstantiationException | IllegalAccessException e) {
                    e.printStackTrace();
                    return null;
                }
            }).collect(Collectors.toList());
        }).getOrElse(Collections.emptyList());

        return new PageImpl<>(list, pageable, total.get());
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        return this.findAllInner(new ExpQuery(), pageable, Sort.unsorted());
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        return this.findIterable(new ExpQuery(), sort);
    }

    @Override
    public Page<T> findAll() {
        return this.findAllInner(new ExpQuery(), Pageable.unpaged(), Sort.unsorted());
    }

    Map<String, Object> getContext() {

        Map<String, Object> context = Optional.ofNullable(contextService).map(ContextService::getAll)
                .orElseGet(Collections::emptyMap);

        return context;
    }

    /**
     * TODO update
     *
     * @param entity
     * @param <S>
     * @return
     */
    @Override
    public <S extends T> S save(S entity) {
        Class<?> aClass = entity.getClass();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(aClass);

        if (persistentEntity != null) {
            IEntityClass schema = persistentEntity.getSchema();

            Map<String, Object> contextMap = getContext();

            Either<? extends ResultStatus, Long> idEither;

            if (entity instanceof BaseEntity) {
                BaseEntity typedEntity = (BaseEntity) entity;
                Map<String, Object> body = ((BaseEntity) entity).getMap();
                if (body != null) {
                    if (((BaseEntity) entity).getId() != null) {
                        //replace
                        CompletionStage<Either<UpdateOneResult, Integer>> replaceResult = entityFacade
                                .replaceById(schema, typedEntity.getId(), body, contextMap);
                        idEither = get(replaceResult).map(x -> {
                            if (x < 0) {
                                logger.warn("update affected row is 0 when update {} : {}", entity.getClass(), typedEntity.getId());
                            }
                            return typedEntity.getId();
                        });
                    } else {
                        CompletionStage<Either<CreateOneResult, Long>> stage = entityFacade.create(schema, body, contextMap);
                        idEither = get(stage);
                    }
                } else {
                    throw new RuntimeException("body should not be null");
                }

                return idEither.mapLeft(x -> x.getMessage()).flatMap(x -> {
                    return get(entityFacade.findOneById(schema, x, contextMap)).mapLeft(ResultStatus::getMessage);
                }).map(x -> {
                    return (S) toEntity(aClass, x);
                }).getOrElseThrow(s -> new RuntimeException(s));
            } else {
                //pojo
                throw new RuntimeException("Current not support non-entity");
            }
        }

        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    private CompletionStage<Either<CreateOneResult, Long>> create(
            Class aClass
            , Object entity
            , IEntityClass entityClass
            , Map<String, Object> context
    ) {
        try {
            Method getMap = aClass.getMethod("getMap");
            Map<String, Object> invoke = (Map) getMap.invoke(entity);
            CompletionStage<Either<CreateOneResult, Long>> stage = entityFacade.create(entityClass, invoke, context);
            return stage;
        } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
            logger.error("{}", e);
            CompletableFuture<Either<CreateOneResult, Long>> future = new CompletableFuture<>();
            future.completeExceptionally(e);
            return future;
        }
    }

    private Object toEntity(Class aClass, Record record) {
        try {
            Object o = aClass.newInstance();
            setRecord(aClass, o, record);
            return o;
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * optimize with batch
     * TODO
     *
     * @param entities
     * @param <S>
     * @return
     */
    @Override
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {

        List<S> linkedList = new LinkedList<>();
        entities.forEach(linkedList::add);

        if (linkedList.size() > 0) {
            S entity = linkedList.get(0);
            Class aClass = entity.getClass();

            OqsPersistentEntity persistentEntity = context.getPersistentEntity(aClass);
            if (persistentEntity != null) {

                IEntityClass schema = persistentEntity.getSchema();
                Map<String, Object> context = Optional.ofNullable(contextService).map(ContextService::getAll)
                        .orElseGet(Collections::emptyMap);

                List<CompletableFuture<Either<CreateOneResult, Long>>> seq = linkedList.stream().map(x -> {
                    return create(aClass, x, schema, context).toCompletableFuture();
                }).collect(Collectors.toList());

                List<Either<CreateOneResult, Long>> idsFuture = CompletableFutureUtils.sequence(seq).join();

                /**
                 * insert error
                 */
                Optional<Either<CreateOneResult, Long>> error = idsFuture.stream()
                        .filter(x -> x.isLeft() && !x.getLeft().getOriginCause().isMute()).findAny();

                if (error.isPresent()) {
                    error.get().getOrElseThrow(x -> new RuntimeException(x.getMessage()));
                } else {
                    //to find s
                    List<CompletableFuture<Either<QueryOneResult, Record>>> records = idsFuture.stream().map(x -> {
                        Long id = x.get();
                        return entityFacade.findOneById(schema, id, context).toCompletableFuture();
                    }).collect(Collectors.toList());

                    List<Either<QueryOneResult, Record>> sequence = get(CompletableFutureUtils.sequence(records));

                    Optional<Either<QueryOneResult, Record>> queryError = sequence.stream().filter(x -> x.isLeft() && !x.getLeft().getOriginCause().isMute()).findAny();
                    if (queryError.isPresent()) {
                        queryError.get().getOrElseThrow(x -> new RuntimeException(x.getMessage()));
                    } else {
                        return sequence.stream().map(x -> {
                            Record record = x.get();
                            return (S) toEntity(aClass, record);
                        }).collect(Collectors.toList());
                    }
                }
            }
        }

        return Collections.emptyList();
    }

    @Override
    public Optional<T> findById(Long id) {
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            CompletionStage<Either<QueryOneResult, Record>> either = entityFacade.findOneById(persistentEntity.getSchema(), id,
                    Optional.ofNullable(contextService).map(ContextService::getAll)
                            .orElse(Collections.emptyMap()));
            return get(either)
                    .toJavaOptional()
                    .map(record -> (T) toEntity(javaType, record));
        }

        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    @Override
    public boolean existsById(Long aLong) {
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);
        if (persistentEntity != null) {

            ExpQuery idCondition = new ExpQuery()
                    .filters(ExpCondition.call(ExpOperator.EQUALS
                            , ExpField.field("id")
                            , ExpValue.fromSingle(aLong)))
                    .sort(ExpSort.init());

            return get(entityFacade.count(persistentEntity.getSchema()
                    , idCondition
                    , Optional.ofNullable(contextService).map(ContextService::getAll)
                            .orElse(Collections.emptyMap())).thenApply(x -> x > 0));
        }

        throw new RuntimeException("Error");
    }

    //TODO java type utils to determine how to deal with it
    @Override
    public Iterable<T> findAllById(Iterable<Long> longs) {
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);
        if (persistentEntity != null) {


            List<Long> ids = new LinkedList<>();
            longs.forEach(ids::add);

            ExpQuery idCondition = new ExpQuery()
                    .filters(ExpCondition.call(ExpOperator.IN
                            , ExpField.field("id")
                            , ids.stream().flatMap(x -> ExpValue.from(x).stream()).collect(Collectors.toList())))
                    .sort(ExpSort.init());

            return findAllInner(idCondition, null, null);
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    @Override
    public long count() {
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);
        if (persistentEntity != null) {

            ExpQuery idCondition = new ExpQuery()
                    .sort(ExpSort.init());

            return get(entityFacade.count(persistentEntity.getSchema()
                    , idCondition
                    , Optional.ofNullable(contextService).map(ContextService::getAll)
                            .orElse(Collections.emptyMap())));
        }

        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    @Override
    public void deleteById(Long aLong) {
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            deleteInner(persistentEntity.getSchema(), Arrays.asList(aLong));
            return;
        }
        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    @Override
    public void delete(T entity) {
        deleteAll(Arrays.asList(entity));
    }

    @Override
    public void deleteAllById(Iterable<? extends Long> longs) {

    }

    private void deleteInner(IEntityClass entityClass, List<Long> ids) {
        List<CompletableFuture<Either<DeleteOneResult, Integer>>> collect = ids.stream().map(id -> {
            return entityFacade.deleteOne(entityClass, id,
                    Optional.ofNullable(contextService).map(ContextService::getAll)
                            .orElse(Collections.emptyMap())).toCompletableFuture();
        }).collect(Collectors.toList());

        /**
         * TODO conflict ??
         */
        List<Either<DeleteOneResult, Integer>> sequence = get(CompletableFutureUtils.sequence(collect));

        Optional<Either<DeleteOneResult, Integer>> queryError = sequence.stream().filter(x -> x.isLeft() && !x.getLeft().getOriginCause().isMute()).findAny();
        queryError.ifPresent(integers -> integers.getOrElseThrow(x -> new RuntimeException(x.getMessage())));
    }

    @Override
    public void deleteAll(Iterable<? extends T> entities) {
        List<Long> ids = new LinkedList<>();
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);
        if (persistentEntity != null) {
            try {

                Method getId = ClassUtils.getMethod(javaType, "getId");
                for (Object entity : entities) {
                    Object id = getId.invoke(entity);
                    ids.add((Long) id);
                }

                deleteInner(persistentEntity.getSchema(), ids);
                return;
            } catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    @Override
    public void deleteAll() {
        deleteAll(findAll());
    }

    @Override
    public T newRecord() {

        Class javaType = entityInformation.getJavaType();

        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);

        try {
            Object o = javaType.newInstance();
            List<IEntityField> fields = persistentEntity.getSchema().fields();
            Method prepare = javaType.getMethod("prepare", Collection.class);
            Object invoke = prepare.invoke(o, fields);
            return (T) o;
        } catch (InstantiationException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }

        return null;
    }

    @Override
    public DataCollection<T> findByExpRel(ExpRel exp) {
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);

        if (persistentEntity != null) {
            IEntityClassGroup reader = entityFacade.getReader(persistentEntity.getSchema(), contextService.getAll());

            ExpContext expContext = new ExpContext().withContext(Optional.ofNullable(contextService)
                    .map(ContextService::getAll)
                    .orElseGet(Collections::emptyMap)).setSchema(reader);
            CompletionStage<Either<QueryResult, DataCollection<Record>>> query = entityFacade
                    .query(expContext, exp);

            return get(query).map(recordList -> {
                List<T> collect = recordList.getRows().stream().map(record -> {
                    return (T) mappingToReturnType(javaType, record);
                }).collect(Collectors.toList());
                DataCollection<T> collection = new DataCollection<>(recordList.getRowNum(), collect);
                return collection;
            }).getOrElseThrow(x -> new RuntimeException(x.getMessage()));
        }

        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    @Override
    public DataCollection<T> findByConditionQueryRequest(ConditionQueryRequest request) {
        return findByExpRel(ExpFactory.createFrom(request));
    }

    //TODO to ExpRel from an Example
    private <S> ExpQuery toExpRel(IEntityClassGroup reader, Example<S> example) {

        Class<S> exampleType = example.getProbeType();

        if (BaseEntity.class.isAssignableFrom(exampleType)) {
            //get record from example
            BaseEntity probe = (BaseEntity) example.getProbe();
            Record record = probe.getRecord();
            return ExpFactory.createFrom(record.toMap(null));
        } else {
            //as a pojo
            S probe = example.getProbe();
            Map<String, Object> propertyMap = new HashMap<>();
            try {
                Map<String, Object> describe = PropertyUtils.describe(probe);

                describe.forEach((k, v) -> {
                    Optional<String> columnName = getColumnName(reader, k);
                    columnName.ifPresent(x -> {
                        propertyMap.put(x, v);
                    });
                });

                return ExpFactory.createFrom(propertyMap);
            } catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
                throw new RuntimeException("Cannot convert example to expRel, reason:" + e.getMessage());
            }
        }
    }

    //TODO page ???
    private <S extends T> CompletionStage<Either<String, DataCollection<Record>>> queryWithExample(Example<S> example, Sort sort, Pageable page) {
        Class javaType = entityInformation.getJavaType();
        OqsPersistentEntity persistentEntity = context.getPersistentEntity(javaType);
        if (persistentEntity != null) {

            IEntityClassGroup reader = entityFacade.getReader(persistentEntity.getSchema(), contextService.getAll());

            ExpQuery expQuery = toExpRel(reader, example);

            ExpSort expSort = ExpSort.init();
            if (sort != null && sort.isSorted()) {
                appendSort(expSort, sort);
            }

            if (page != null && page.isPaged()) {
                appendPage(expQuery, page);
            }

            ExpContext expContext = new ExpContext().withContext(Optional.ofNullable(contextService)
                    .map(ContextService::getAll)
                    .orElseGet(Collections::emptyMap)).setSchema(reader);

            CompletionStage<Either<QueryResult, DataCollection<Record>>> query = entityFacade
                    .query(expContext, expQuery);

            return query.thenApply(x -> x.mapLeft(ResultStatus::getMessage));
        }

        throw new RuntimeException(ENTITY_NOT_FOUND);
    }

    /**
     * query by example
     *
     * @param example
     * @param <S>
     * @return
     */
    @Override
    public <S extends T> Optional<S> findOne(Example<S> example) {

        CompletionStage<Either<String, DataCollection<Record>>> query = queryWithExample(example, null, null);

        return get(query)
                .toJavaOptional()
                .map(recordList -> {
                    if (recordList.getRowNum() > 1) {
                        throw new RuntimeException("Found Record more than 1 with findOne");
                    } else {
                        Record record = recordList.getRows().get(0);
                        return (S) mappingToReturnType(example.getProbeType(), record);
                    }
                });
    }


    private <S extends T> DataCollection<S> findAll(Example<S> example, Sort sort, Pageable page) {
        CompletionStage<Either<String, DataCollection<Record>>> query = queryWithExample(example, sort, page);
        return get(query)
                .toJavaOptional()
                .map(recordList -> {
                    List<S> collect = recordList.getRows().stream().map(record -> {
                        return (S) mappingToReturnType(example.getProbeType(), record);
                    }).collect(Collectors.toList());
                    DataCollection<S> collection = new DataCollection<>(recordList.getRowNum(), collect);
                    return collection;
                }).orElseGet(() -> {
                    DataCollection<S> dataCollection = new DataCollection<>(0, Collections.emptyList());
                    return dataCollection;
                });
    }

    @Override
    public <S extends T> Iterable<S> findAll(Example<S> example) {
        return findAll(example, null, null).getRows();
    }

    @Override
    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        return findAll(example, sort, null).getRows();
    }

    @Override
    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        DataCollection<S> dc = findAll(example, null, pageable);
        List<S> list = dc.getRows();
        Integer total = dc.getRowNum();
        return new PageImpl<>(list, pageable, total);
    }

    @Override
    public <S extends T> long count(Example<S> example) {
        return findAll(example, null, PageRequest.of(1, 1)).getRowNum();
    }

    @Override
    public <S extends T> boolean exists(Example<S> example) {
        return count(example) > 0;
    }

    @Override
    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        return null;
    }

    //TODO same in SimpleQuery
    private Object mappingToReturnType(Class<?> classType, Record record) {
        if (BaseEntity.class.isAssignableFrom(classType)) {
            //a entity class
            //TODO entity class mapping
//            throw new RuntimeException("TODO");
            try {
                Object o = classType.newInstance();

                Field[] allFields = FieldUtils.getAllFields(classType);
                Optional<Field> record2 = Arrays.stream(allFields)
                        .filter(field -> field.getName().equalsIgnoreCase("record"))
                        .findFirst();

                record2.ifPresent(recordField -> {
                    try {
                        recordField.setAccessible(true);
                        recordField.set(o, record);
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                });

                return o;
            } catch (InstantiationException | IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        } else {
            return record.into(classType);
        }
    }
}
