package com.xforceplus.oqsengine.sdk.reexploit.spring.model;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.GeneralRecord;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * TODO
 */
public class BaseEntity {

    private static final String RECORD_NOT_INITED = "record is not inited";

    protected Record record;

    /**
     * TODO is general?
     * @return
     */
    List<String> getBusinessKey(){
        return Collections.emptyList();
    }

    public BaseEntity(){
    }

    public Long getId(){
        if(record != null) {
            return record.getId();
        }
        return -1L;
    }

    public void prepare(Collection<? extends IEntityField> fields){
        record = new GeneralRecord(fields);
    }

    public void from(Map<String, Object> mapping){
        record.fromMap(mapping);
    }

    public Map<String, Object> getMap(){
        if(record != null){
            return record.toMap(Collections.emptySet());
        }
        return null;
    }

    public Record getRecord() {
        return record;
    }

    public <T> BaseEntity set(TypedField<T> typedField, T t){
        if(record != null){
            record.set(typedField, t);
        } else {
            throw new RuntimeException(RECORD_NOT_INITED);
        }

        return this;
    }

    public BaseEntity set(String key, Object value) {
        if(record != null){
            record.set(key, value);
        } else {
            throw new RuntimeException(RECORD_NOT_INITED);
        }

        return this;
    }

    public Object get(String key){
        return record.get(key).orElse(null);
    }

    @Override
    public String toString() {
        return record != null ? record.toMap(Collections.emptySet()).toString() : "Record is Empty";
    }
}
