package com.xforceplus.oqsengine.sdk.reexploit.spring.model;

import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsMappingContext;
import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsPersistentEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.annotation.OqsEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;

public class Domain {

    private OqsMappingContext mappingContext;

    /**
     * general one for Class or IEntityClass
     */
    private OqsPersistentEntity<?> entity;

    private String code;


    public Domain(OqsMappingContext mappingContext, Class<?> entityClass) {
        this.mappingContext = mappingContext;
        this.entity = mappingContext.getRequiredPersistentEntity(entityClass);
        this.internalInitialize();
    }

    /**
     * initialize
     */
    private void internalInitialize() {
        if(this.entity.isAnnotationPresent(OqsEntity.class)){
            this.code = this.entity.getRequiredAnnotation(OqsEntity.class).value();
        }
    }

    public OqsMappingContext getMappingContext() {
        return mappingContext;
    }

    public OqsPersistentEntity<?> getEntity() {
        return entity;
    }

    public String getCode() {
        return code;
    }

    public IEntityClass getEntityClass() {
        return entity.getSchema();
    }
}
