package com.xforceplus.oqsengine.sdk.reexploit.spring.query;

import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsMappingContext;
import com.xforceplus.oqsengine.sdk.reexploit.spring.annotation.OqsEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.model.BaseEntity;
import com.xforceplus.oqsengine.sdk.reexploit.spring.model.Domain;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.facade.EntityFacade;
import com.xforceplus.ultraman.oqsengine.sdk.facade.result.ResultStatus;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import com.xforceplus.ultraman.oqsengine.sdk.facade.ProfileFetcher;
import com.xforceplus.ultraman.oqsengine.sdk.utils.PropertyHelperEx;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import io.vavr.control.Either;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.*;
import org.springframework.data.repository.query.parser.OqsPartTree;
import org.springframework.data.util.DynamicEntityTypeInformation;
import org.springframework.util.Assert;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleQuery implements RepositoryQuery {

    protected OqsQueryMethod queryMethod;

    private OqsMappingContext mappingContext;

    private EntityFacade entityFacade;

    private ProfileFetcher fetcher;

    private OqsPartTree tree;

    public SimpleQuery(OqsQueryMethod method, EntityFacade entityFacade, RepositoryMetadata metadata, OqsMappingContext context) {
        this.queryMethod = method;
        this.mappingContext = context;
        this.entityFacade = context.getEntityService();

        Class<?> domainType = metadata.getDomainType();
        OqsEntity annotation = domainType.getAnnotation(OqsEntity.class);
        if (annotation != null) {
            String code = annotation.value();
            Map<String, Object> all = context.getContextService().getAll();
            String profile = fetcher.getProfile(all);
            Optional<IEntityClass> iEntityClass = mappingContext.getEntityService().loadByCode(code, profile);
            IEntityClass realEntity = iEntityClass.orElseThrow(() -> new RuntimeException("Code not exists " + code));
            this.tree = new OqsPartTree(queryMethod.getName(), new DynamicEntityTypeInformation<>(entityFacade.getReader(realEntity, all)
                    , queryMethod.getResultProcessor().getReturnedType().getDomainType(), profile));
        } else {
            this.tree = new OqsPartTree(queryMethod.getName(), queryMethod.getResultProcessor().getReturnedType().getDomainType());
        }
    }

    //TODO check the return type
    @Override
    public Object execute(Object[] parameters) {

        Class<?> clazz = queryMethod.getResultProcessor().getReturnedType().getDomainType();
        Domain requiredDomain = mappingContext.getRequiredDomain(clazz);
        IEntityClass entityClass = requiredDomain.getEntityClass();

        Map<String, Object> all = mappingContext.getContextService().getAll();
        String profile = fetcher.getProfile(all);

        EntityFacade entityFacade = mappingContext.getEntityService();
        IEntityClassGroup reader = entityFacade.getReader(entityClass, all);

        ParametersParameterAccessor accessor = new ParametersParameterAccessor(queryMethod.getParameters(), parameters);
        ExpQuery query = createQuery(accessor, reader);
        Assert.notNull(query, "unsupported query");

        Class<?> returnedObjectType = queryMethod.getReturnedObjectType();
        Field[] allFields = FieldUtils.getAllFields(returnedObjectType);

        /**
         * TODO close projection
         */
        List<ExpNode> projections = Stream.of(allFields).map(x -> {
            return PropertyHelperEx.getColumnName(reader, x.getName());
        }).filter(Optional::isPresent)
                .map(x -> ExpField.field(x.get()))
                .collect(Collectors.toList());

        query.project(projections);

        /**
         * TODO open projection
         */
        ExpContext expContext = new ExpContext()
                .withContext(Optional.ofNullable(mappingContext.getContextService().getAll())
                        .orElse(Collections.emptyMap())).setSchema(reader);

        /**
         * TODO
         */
        Either<String, DataCollection<Record>> result = entityFacade
                .query(expContext, query)
                .toCompletableFuture()
                .join().mapLeft(ResultStatus::getMessage);

        return result.map(data -> data.getRows()
                .stream().map(x -> {
                    ParametersParameterAccessor objects = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
                    ResultProcessor resultProcessor = queryMethod.getResultProcessor().withDynamicProjection(objects);
                    if (returnedObjectType == clazz) {
                        try {
                            Object o = returnedObjectType.newInstance();
                            Field record = FieldUtils.getField(returnedObjectType, "record", true);
                            record.set(o, x);
                            return o;
                        } catch (InstantiationException | IllegalAccessException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    return resultProcessor.processResult(x, new RecordConverter(resultProcessor.getReturnedType()));
                }).collect(Collectors.toList()))
                .getOrElseThrow(x -> new RuntimeException(x));
    }

    /**
     * TODO
     * mapping
     *
     * @param classType
     */
    private Object mappingToReturnType(Class<?> classType, Record record) {
        if (BaseEntity.class.isAssignableFrom(classType)) {
            //a entity class
            //TODO entity class mapping
//            throw new RuntimeException("TODO");
            try {
                Object o = classType.newInstance();

                Field[] allFields = FieldUtils.getAllFields(classType);
                Optional<Field> record2 = Arrays.stream(allFields)
                        .filter(field -> field.getName().equalsIgnoreCase("record"))
                        .findFirst();

                record2.ifPresent(recordField -> {
                    try {
                        recordField.setAccessible(true);
                        recordField.set(o, record);
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                });

                return o;
            } catch (InstantiationException | IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        } else {
           return record.into(classType);
        }
    }

    @Override
    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public ExpQuery createQuery(ParametersParameterAccessor accessor, IEntityClassGroup reader) {
        return new OqsQueryCreator(tree, accessor, reader).createQuery();
    }

    class RecordConverter implements Converter<Object, Object> {

        private final ReturnedType type;

        RecordConverter(ReturnedType type) {

            Assert.notNull(type, "Returned type must not be null!");
            this.type = type;
        }

        @Override
        public Object convert(Object source) {
            return mappingToReturnType(type.getReturnedType(), (Record) source);
        }
    }
}

