package org.springframework.data.util;

import com.xforceplus.oqsengine.sdk.reexploit.spring.OqsEntityPersistentPropertyImpl;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.pojo.utils.OptionalHelper;
import com.xforceplus.ultraman.oqsengine.pojo.utils.PropertyHelper;
import com.xforceplus.ultraman.oqsengine.sdk.store.engine.IEntityClassGroup;
import org.springframework.data.mapping.model.SnakeCaseFieldNamingStrategy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * create entity type information from type and entityclass
 * @param <S>
 */
public class DynamicEntityTypeInformation<S> implements TypeInformation<S> {

    private Class<S> type;

    private IEntityClassGroup reader;

    private String profile;

    public DynamicEntityTypeInformation(IEntityClassGroup reader, Class<S> type, String profile) {
        this.type = type;
        this.reader = reader;
        this.profile = profile;
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Constructor<?> constructor) {
        return null;
    }

    @Override
    public TypeInformation<?> getProperty(String property) {

        String snakeCase = PropertyHelper.camelToBoProperty(property, true);
        String camelCase = PropertyHelper.camelToBoProperty(property, false);

        Optional<ColumnField> columnSnake = reader.column(snakeCase);
        Optional<ColumnField> columnCamel = reader.column(camelCase);

        Optional<ColumnField> combine = OptionalHelper.combine(columnCamel, columnSnake);

        if(combine.isPresent()){
            FieldType type = combine.get().type();
            return ClassTypeInformation.from(type.getJavaType());
        }else{
            throw new RuntimeException(property + " not found in " + reader.getEntityClass().code());
        }
    }

    @Override
    public boolean isCollectionLike() {
        return false;
    }

    @Override
    public TypeInformation<?> getComponentType() {
        return null;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public TypeInformation<?> getMapValueType() {
        return null;
    }

    @Override
    public Class<S> getType() {
        return type;
    }

    @Override
    public ClassTypeInformation<?> getRawTypeInformation() {
        return null;
    }

    @Override
    public TypeInformation<?> getActualType() {
        return null;
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        return null;
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Method method) {
        return null;
    }

    @Override
    public TypeInformation<?> getSuperTypeInformation(Class<?> superType) {
        return null;
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        return false;
    }

    @Override
    public List<TypeInformation<?>> getTypeArguments() {
        return null;
    }

    @Override
    public TypeInformation<? extends S> specialize(ClassTypeInformation<?> type) {
        return null;
    }

    public IEntityClass getEntityClass() {
        return reader.getEntityClass();
    }

    public void setType(Class<S> type) {
        this.type = type;
    }

    public IEntityClassGroup getReader() {
        return reader;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DynamicEntityTypeInformation<?> that = (DynamicEntityTypeInformation<?>) o;
        return Objects.equals(type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type);
    }
}
