/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.parser;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.OqsPart;
import org.springframework.data.repository.query.parser.OqsPartTree;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class OqsAbstractQueryCreator<T, S> {
    private final Optional<ParameterAccessor> parameters;
    private final OqsPartTree tree;

    public OqsAbstractQueryCreator(OqsPartTree tree) {
        this(tree, Optional.empty());
    }

    public OqsAbstractQueryCreator(OqsPartTree tree, ParameterAccessor parameters) {
        this(tree, Optional.of(parameters));
    }

    private OqsAbstractQueryCreator(OqsPartTree tree, Optional<ParameterAccessor> parameters) {
        Assert.notNull((Object)tree, (String)"PartTree must not be null");
        Assert.notNull(parameters, (String)"ParameterAccessor must not be null");
        this.tree = tree;
        this.parameters = parameters;
    }

    public T createQuery() {
        return this.createQuery(this.parameters.map(ParameterAccessor::getSort).orElse(Sort.unsorted()), this.parameters.map(ParameterAccessor::getPageable).orElse(Pageable.unpaged()));
    }

    public T createQuery(Sort dynamicSort, Pageable pageable) {
        Assert.notNull((Object)dynamicSort, (String)"DynamicSort must not be null!");
        return this.complete(this.createCriteria(this.tree), this.tree.getSort().and(dynamicSort), pageable);
    }

    @Nullable
    private S createCriteria(OqsPartTree tree) {
        S base = null;
        Iterator<Object> iterator = this.parameters.map(ParameterAccessor::iterator).orElse(Collections.emptyIterator());
        Iterator<OqsPartTree.OrPart> iterator2 = tree.iterator();
        while (iterator2.hasNext()) {
            OqsPartTree.OrPart node = iterator2.next();
            Iterator<OqsPart> parts = node.iterator();
            if (!parts.hasNext()) {
                throw new IllegalStateException(String.format("No part found in PartTree %s!", tree));
            }
            S criteria = this.create(parts.next(), iterator);
            while (parts.hasNext()) {
                criteria = this.and(parts.next(), criteria, iterator);
            }
            base = (S)(base == null ? criteria : this.or(base, criteria));
        }
        return base;
    }

    protected abstract S create(OqsPart var1, Iterator<Object> var2);

    protected abstract S and(OqsPart var1, S var2, Iterator<Object> var3);

    protected abstract S or(S var1, S var2);

    protected abstract T complete(@Nullable S var1, Sort var2, Pageable var3);
}

