package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.utils.MetadataEngineHolder;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.calcite.UltramanSchema;
import com.xforceplus.ultraman.sdk.core.calcite.UltramanSchemaFactory;
import com.xforceplus.ultraman.sdk.core.calcite.hints.HintTools;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.proxy.ProxyConnection;
import com.xforceplus.ultraman.sdk.core.calcite.type.ExtendedRelDataTypeSystem;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.invoke.InvocationManager;
import com.xforceplus.ultraman.sdk.core.invoke.impl.SchemaBasedInvocationManager;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.calcite.jdbc.CalciteJdbc41Factory;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

import javax.sql.DataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

import static com.xforceplus.metadata.schema.dsl.Step.APP;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.LABEL_INDEX;

@Slf4j
@Configuration
public class ConnectionAutoConfiguration {

    @Bean
    public InvocationManager manager(ExecutionConfig executionConfig){
        return new SchemaBasedInvocationManager(executionConfig.getRateLimiter(), executionConfig.getUseCircuitBreaker());
    }

    /**
     *
     * @param metadataEngine
     * @param classEngine
     * @param queryProvider
     * @return
     */
    @Lazy
    @Bean
    public FrameworkConfig frameworkConfig(MetadataEngine metadataEngine, EntityClassEngine classEngine, DataQueryProvider queryProvider
            , ProfileFetcher fetcher, ContextService contextService, InvocationManager invocationManager) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema(true, false).plus();
        List<Map<String, Object>> appList = metadataEngine.getMulti(__.has(LABEL_INDEX, APP));

        appList.forEach(x -> {
            String code = x.get("code").toString();
            UltramanSchema ultramanSchema = new UltramanSchema(code, MetadataEngineHolder.get()
                    , classEngine, queryProvider, invocationManager, fetcher, contextService);
            rootSchema.add(code, ultramanSchema);
        });

        SqlParser.Config insensitiveParser = SqlParser.configBuilder()
                .setCaseSensitive(false)
                .build();

        FrameworkConfig config = Frameworks.newConfigBuilder()
                .parserConfig(insensitiveParser)
                .defaultSchema(rootSchema)
                .typeSystem(new ExtendedRelDataTypeSystem())
                .sqlToRelConverterConfig(SqlToRelConverter.config()
                        .withHintStrategyTable(HintTools.HINT_STRATEGY_TABLE)
                        .withInSubQueryThreshold(5000))
                .build();

        //warm up!!!!
        RelBuilder relBuilder = RelBuilder.create(config);
        return config;
    }

    @Lazy
    @Bean(name = "CalciteDS")
    public DataSource ultramanConnection(MetadataEngine metadataEngine, EntityClassEngine entityClassEngine, DataQueryProvider dataQueryProvider
            , ProfileFetcher fetcher, ContextService contextService, InvocationManager invocationManager) throws SQLException {

        //Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        // Get Calcite-specific connection object
        //CalciteConnection calciteConn = connection.unwrap(CalciteConnection.class);
        CalciteSchema rootSchema = CalciteSchema.createRootSchema(true, false);

        /**
         * TODO create schema
         */
        UltramanSchemaFactory factory = new UltramanSchemaFactory(metadataEngine, entityClassEngine, dataQueryProvider
                , invocationManager, fetcher, contextService);
        Schema schema = factory.create(rootSchema.plus(), "", Collections.emptyMap());
        rootSchema.add("", schema);

        CalciteJdbc41Factory calciteJdbc41Factory = new CalciteJdbc41Factory();
        Properties info = new Properties();
        info.setProperty("caseSensitive", "false");
        info.setProperty("lex", "MYSQL");
        info.setProperty("conformance", "MYSQL_5");
        HikariConfig config = new HikariConfig();
        config.setDataSource(new DataSource() {

            @Override
            public Connection getConnection() throws SQLException {
                CalciteSchema rootSchema = CalciteSchema.createRootSchema(true, false);
                Schema schema = factory.create(rootSchema.plus(), "", Collections.emptyMap());
                rootSchema.add("", schema);
                Connection connection = calciteJdbc41Factory.newConnection(new Driver(), calciteJdbc41Factory, "jdbc:calcite:", info, rootSchema, null);
                log.debug("Create Calcite new connection");
                return new ProxyConnection(connection);
            }

            @Override
            public Connection getConnection(String username, String password) throws SQLException {
                return getConnection();
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return false;
            }

            @Override
            public PrintWriter getLogWriter() throws SQLException {
                return null;
            }

            @Override
            public void setLogWriter(PrintWriter out) throws SQLException {

            }

            @Override
            public void setLoginTimeout(int seconds) throws SQLException {

            }

            @Override
            public int getLoginTimeout() throws SQLException {
                return 0;
            }

            @Override
            public Logger getParentLogger() throws SQLFeatureNotSupportedException {
                return null;
            }
        });

        HikariDataSource dataSource = new HikariDataSource(config);
        config.setMaximumPoolSize(50);
        return dataSource;
    }
}
