package com.xforceplus.ultraman.starter.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.config.ExportConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.ValidatorConfig;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.base.CdcConfig;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import org.checkerframework.checker.units.qual.C;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * a global setting for sdk
 */
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.enabled", matchIfMissing = true)
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "xplat.oqsengine.sdk")
@Configuration
public class SdkConfiguration {


    @Autowired
    private ObjectMapper mapper;

    /**
     * auth:
     * tenant
     * appId
     * branch
     * role
     * env
     */
    private AuthConfig auth = new AuthConfig();

    private CdcConfig cdc = new CdcConfig();

    private ExecutionConfig exec = new ExecutionConfig();

    private ExportConfig export = new ExportConfig();

    private ValidatorConfig validators = new ValidatorConfig();

    public ValidatorConfig getValidators() {
        return validators;
    }

    public void setValidators(ValidatorConfig validators) {
        this.validators = validators;
    }

    public AuthConfig getAuth() {
        return auth;
    }

    public void setAuth(AuthConfig auth) {
        this.auth = auth;
    }

    public ExecutionConfig getExec() {
        return exec;
    }

    public void setExec(ExecutionConfig exec) {
        this.exec = exec;
    }

    public ExportConfig getExport() {
        return export;
    }

    public void setExport(ExportConfig export) {
        this.export = export;
    }

    public CdcConfig getCdc() {
        return cdc;
    }

    public void setCdc(CdcConfig cdc) {
        this.cdc = cdc;
    }
}
