package com.xforceplus.ultraman.starter.autoconfigure;

import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ActorAutoConfiguration {

    /**
     * default system
     *
     * @return
     */
    @Bean(destroyMethod = "terminate")
    @ConditionalOnMissingBean(ActorSystem.class)
    public ActorSystem actorSystem() {
        return ActorSystem.create();
    }

    /**
     * default mat
     *
     * @param system
     * @return
     */
    @Bean
    @ConditionalOnMissingBean(ActorMaterializer.class)
    public ActorMaterializer mat(ActorSystem system) {
        return ActorMaterializer.create(system);
    }
}
