package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.sdk.infra.event.impl.EventEngineImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
public class EventConfiguration {

    @Bean
    public EventEngine refreshableFactory(List<Refreshable> refreshableList){
        EventEngine eventEngine = new EventEngineImpl();
        refreshableList.forEach(x -> {
            eventEngine.register(UltramanLifecycle.METADATA_REFRESHED, x);
        });

        return eventEngine;
    }

}
