/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.config.ExportConfig;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.index.IndexConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.impl.TenantContextProfile;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.invocation.invoke.config.InvocationConfig;
import com.xforceplus.ultraman.starter.autoconfigure.SdkConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfigureBefore(name={"com.xforceplus.ultraman.starter.autoconfigure.EventConfiguration"})
@EnableConfigurationProperties(value={SdkConfiguration.class})
@ConditionalOnProperty(value={"xplat.oqsengine.sdk.enabled"}, matchIfMissing=true)
public class SdkAutoConfiguration {
    @Bean
    public InvocationConfig invocationConfig(SdkConfiguration sdkConfiguration) {
        return new InvocationConfig();
    }

    @Bean
    public AuthConfig authConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getAuth();
    }

    @Bean
    public ExecutionConfig execConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getExec();
    }

    @Bean
    public IndexConfig indexConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getIndex();
    }

    @Bean
    public ExportConfig exportConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getExport();
    }

    @Bean
    public CdcConfig cdcConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getCdc();
    }

    @Bean
    public DynamicConfig dynamic(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getDynamic();
    }

    @Bean
    public GlobalInited globalInited(ExecutionConfig executionConfig) {
        return new GlobalInited(Integer.valueOf(executionConfig.getInitSize()), Integer.valueOf(executionConfig.getInitTimeout()));
    }

    @Bean
    public ProfileFetcher profileFetcher(ContextService contextService) {
        return new TenantContextProfile(contextService);
    }
}

