create table devops
(
     batchid bigint default 0 not null comment '批量任务ID',
     maintainid bigint not null comment '任务批次ID',
     entity bigint not null comment 'entity 的类型 id.',
     starts bigint default 0 not null comment '任务范围起始时间',
     ends bigint default 0 not null comment '任务范围终止时间',
     batchsize int default 0 not null comment '任务总数',
     finishsize int default 0 not null comment '任务已处理数',
     status int default 0 not null comment '状态',
     createtime bigint not null comment '任务创建时间',
     updatetime bigint default null comment '任务结束时间',
     message varchar(512) default null comment '任务摘要',
     startid bigint default 0 not null comment '已用作记录失败的数量',
     profile varchar(128) default null comment 'profile',
     constraint devopstasks_pk0 primary key (maintainid),
     key devopstasks_k0 (entity),
     key devopstasks_k1 (batchid)
) ENGINE=InnoDB DEFAULT CHARSET = utf8mb4;

------

create table compares
(
     batchid bigint default 0 not null comment '批量任务ID',
     taskid bigint not null comment '任务批次ID',
     entity bigint not null comment 'entity 的类型 id.',
     profile varchar(128) default null comment 'profile',
     starts bigint default 0 not null comment '任务范围起始时间',
     ends bigint default 0 not null comment '任务范围终止时间',
     status int default 0 not null comment '状态',
     createtime bigint not null comment '任务创建时间',
     updatetime bigint default null comment '任务结束时间',
     difference longtext comment '差异',
     mastertotal bigint comment '主库比对数量',
     excessive longtext comment '多余',
     indextotal bigint comment '索引比对数量',
     message varchar(512) default null comment '任务摘要',
     repairstatus int default 0 not null comment '状态',
     constraint compares_pk0 primary key (taskid),
     key compares_k0 (entity),
     key compares_k1 (batchid)
) ENGINE=InnoDB DEFAULT CHARSET = utf8mb4;

------

create table history
(
     id bigint not null comment '唯一标识号',
     batchid bigint not null comment '批量任务ID',
     taskid bigint not null comment '任务批次ID',
     part int not null comment '第几部分',
     entity bigint not null comment 'entity 的类型 id.',
     profile varchar(128) default null comment 'profile',
     filterprofile varchar(128) default null comment 'filterprofile',
     starts bigint default 0 not null comment '任务范围起始时间',
     ends bigint default 0 not null comment '任务范围终止时间',
     years int default 0 not null comment '任务年份',
     months int default 0 not null comment '任务月份',
     status int default 0 not null comment '状态',
     createtime bigint not null comment '任务创建时间',
     updatetime bigint default null comment '任务结束时间',
     deletetime bigint default null comment '删除任务时间',
     total bigint default 0 not null comment '总数量',
     documents bigint default 0 not null comment '总迁移完成数量',
     deletes bigint default 0 not null comment '总删除完成数量',
     checkpoint bigint default 0 not null comment '当前的迁移检查点',
     deletepoint bigint default 0 not null comment '当前的删除检查点',
     message varchar(512) default null comment '任务摘要',
     op int not null comment '操作',
     opuser bigint comment '操作人ID',
     opusername varchar(128) comment '操作人姓名',
     deleteuser bigint comment '删除操作人ID',
     deleteusername varchar(128) comment '删除操作人姓名',
     tablename varchar(256) comment '目标表名',
     constraint compares_pk0 primary key (id),
     key compares_k0 (taskid),
     key compares_k1 (batchid),
     key compares_k2 (entity)
) ENGINE=InnoDB DEFAULT CHARSET = utf8mb4;

------

CREATE TABLE `node_seq` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `current_value` int DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

------

CREATE TABLE `cdc_status` (
  `id` bigint NOT NULL,
  `profile` varchar(50) DEFAULT NULL,
  `entityclass_id` bigint DEFAULT NULL,
  `update_time` bigint DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_cdc_status` (`update_time`,`entityclass_id`,`profile`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

------

CREATE TABLE `distributed_lock` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lock_key` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `expireAt` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_lock_lock_key` (`lock_key`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;