package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.invocation.invoke.InvocationManager;
import com.xforceplus.ultraman.sdk.core.invocation.impl.QueryBasedInvocationManager;
import com.xforceplus.ultraman.sdk.core.invocation.impl.SimpleInvocationManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
public class InvocationManagerAutoConfiguration {

    @ConditionalOnProperty(value = "xplat.oqsengine.sdk.invocation.advanced.enabled", matchIfMissing = true)
    @Bean
    public InvocationManager<List<Object>> queryBasedInvocationManager(ExecutionConfig executionConfig) {
        return new QueryBasedInvocationManager(executionConfig);
    }

    @ConditionalOnMissingBean(InvocationManager.class)
    @Bean
    public InvocationManager<List<Object>> simpleInvocationManager() {
        return new SimpleInvocationManager();
    }
}
