package com.xforceplus.ultraman.starter.autoconfigure;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.infrastructure.http.DefaultHttp;
import com.xforceplus.tech.infrastructure.http.HttpComponent;
import com.xforceplus.tech.metadata.spec.Metadata;
import com.xforceplus.ultraman.agent.model.Database;
import com.xforceplus.ultraman.agent.model.ProjectInitRequest;
import com.xforceplus.ultraman.client.api.AgentApi;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.config.ExportConfig;
import com.xforceplus.ultraman.sdk.core.config.ClusterConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.index.IndexConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.impl.TenantContextProfile;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.utils.ConfigUtils;
import com.xforceplus.ultraman.sdk.infra.utils.DDLUtils;
import com.xforceplus.ultraman.sdk.invocation.invoke.config.InvocationConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.data.repository.cdi.Eager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@AutoConfigureBefore(name =  {"com.xforceplus.ultraman.starter.autoconfigure.EventConfiguration", "com.xforceplus.ultraman.adapter.config.LocalOqsengineAutoConfiguration"})
@EnableConfigurationProperties(SdkConfiguration.class)
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.enabled", matchIfMissing = true)
public class SdkAutoConfiguration {
    
    @Bean
    public InvocationConfig invocationConfig(SdkConfiguration sdkConfiguration) {
        return new InvocationConfig();
    }
    
    @Bean
    public AuthConfig authConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getAuth();
    }

    @Bean
    public ExecutionConfig execConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getExec();
    }

    @Bean
    public IndexConfig indexConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getIndex();
    }

    @Bean
    public ExportConfig exportConfig(SdkConfiguration sdkConfiguration)  {
        return sdkConfiguration.getExport();
    }

    @Bean
    public CdcConfig cdcConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getCdc();
    }

    @Bean
    public DynamicConfig dynamic(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getDynamic();
    }

    @Bean
    public ClusterConfig clusterConfig(SdkConfiguration sdkConfiguration) {
        return sdkConfiguration.getCluster();
    }
    
    @Bean
    public GlobalInited globalInited(ExecutionConfig executionConfig) {
        return new GlobalInited(
                executionConfig.getInitSize()
                , executionConfig.getInitTimeout());
    }

    @Bean
    public ProfileFetcher profileFetcher(ContextService contextService){
        return new TenantContextProfile(contextService);
    }
    
    @Order(Ordered.HIGHEST_PRECEDENCE)
    @Bean
    public AgentApi agentApi(@Value("${xplat.oqsengine.sdk.agent.url:http://localhost}") String agentUrl
            , @Value("${xplat.oqsengine.sdk.agent.init:false}") Boolean needInit
            , AuthConfig authConfig
            , DynamicConfig dynamicConfig                 
            , Environment environment) {


        HttpComponent httpComponent = new DefaultHttp();
        Map<String, String> map = new HashMap<>();
        map.put("http.readTimeout", "60000");
        map.put("http.readTimeout", "60000");
        Config tagetConfig = ConfigFactory.parseMap(map);
        Metadata metadata = new Metadata(tagetConfig);
        httpComponent.init(metadata);
        
        AgentApi agentApi = httpComponent.create(agentUrl, AgentApi.class);
        if(needInit) {
            try {
                ProjectInitRequest request = new ProjectInitRequest();
                request.setProjectId(authConfig.getAppId());
                request.setProjectCode(authConfig.getAppCode());
                //TODO

//                String[] activeProfiles = environment.getActiveProfiles();
                String env;
//                if (activeProfiles.length > 0) {
//                    env = activeProfiles[0];
//                } else {
//                    env = "dev";
//                }
                env = authConfig.getEnv();

                if ("0".equalsIgnoreCase(env)) {
                    env = "dev";
                } else if ("1".equalsIgnoreCase(env)) {
                    env = "fat";
                } else if ("2".equalsIgnoreCase(env)) {
                    env = "prod";
                } else if ("3".equalsIgnoreCase(env)) {
                    env = "sit";
                } else if("5".equalsIgnoreCase(env)) {
                    env = "demo";
                } else if("6".equalsIgnoreCase(env)) {
                    env = "uat";
                }

                Config config = ConfigUtils.getConfig(environment);
                List<Config> dsConfigList = ConfigUtils.getDSConfigList(config);

                String finalEnv = env;
                List<Database> databaseList = dsConfigList.stream().map(mainDSConfig -> {
                    Database database = new Database();
                    database.setEnv(finalEnv);
                    database.setJdbcUrl(mainDSConfig.getString("jdbcUrl"));
                    database.setAdminUser(mainDSConfig.getString("username"));
                    database.setAdminPwd(mainDSConfig.getString("password"));
                    database.setDbType("local");

                    try {
                        URI uri = new URI(database.getJdbcUrl().substring("jdbc:".length()));
                        String path = uri.getPath();
                        database.setDbSchema(path.substring(1));
                    } catch (Throwable throwable) {

                    }

                    return database;
                }).collect(Collectors.toList());

                //TODO using dynamicConfig to find related tenantCode 
                if (databaseList.size() == 1) {
                    request.setDatabase(databaseList.get(0));
                    request.setTenantMode(false);
                } else {
                    Map<String, Database> mapping = new HashMap<>();
                    Integer index = 0;
                    for (Database database : databaseList) {
                        mapping.put("master-".concat(index.toString()), database);
                        index++;
                    }
                    request.setTenantDatabases(mapping);
                    request.setTenantMode(true);
                }

                //init script
                InputStream resourceAsStream = getClass().getResourceAsStream("/init/init.sql");

                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream))) {
                    // Read lines from the input stream and collect them into a string
                    String collect = reader.lines().collect(Collectors.joining("\n"));
                    Map<String, String> stringStringMap = DDLUtils.extractTableDDLs(collect);
                    request.setScripts(stringStringMap);

                } catch (IOException e) {
                    throw new RuntimeException("Failed to read init", e);
                }

                com.xforceplus.ultraman.agent.model.Response response = agentApi.initProject(request);
            } catch (Throwable throwable ){
                log.error("failed to init project", throwable);
            }
        }

        return agentApi;
    }
}
