package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.*;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.*;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRegexCheckedConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRequiredConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.query.ExpRangeValidator;
import com.xforceplus.ultraman.sdk.core.pipeline.query.ExpTreeValidatorImpl;
import com.xforceplus.ultraman.sdk.core.rel.legacy.transformer.ExpTreeTransformer;
import com.xforceplus.ultraman.sdk.core.rel.legacy.transformer.impl.QueryValueHandlerTransformer;
import com.xforceplus.ultraman.sdk.core.rel.legacy.validate.ExpTreeValidator;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import org.apache.calcite.util.ConversionUtil;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;


@ConditionalOnProperty(value = "xplat.oqsengine.sdk.enabled", matchIfMissing = true)
@DependsOn({"bocpClient", "sdkEventConsumer"})
public class UltramanAutoConfiguration {

    static {
        System.setProperty("saffron.default.charset", ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.nationalcharset",ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.collation.name",ConversionUtil.NATIVE_UTF16_CHARSET_NAME + "$en_US");
        System.setProperty("calcite.bindable.cache.maxSize", "1000");
    }

    @Bean
    public ExpTreeTransformer QueryValueHandlerTransformer(List<QuerySideFieldOperationHandler> querySideFieldOperationHandler) {
        return new QueryValueHandlerTransformer(querySideFieldOperationHandler);
    }

    @ConditionalOnMissingBean(TransformerPipeline.class)
    @Bean
    public TransformerPipeline transformerPipeline(
            List<FieldOperationHandler> fieldOperationHandlers
            , List<FieldValidator<Object>> fieldValidators
            , List<ExpTreeTransformer> treeTransformers
            , List<ExpTreeValidator> treeValidators
            , ContextService contextService
            , ExecutionConfig executionConfig
    ) {
        //add elastic search
        return new TransformerPipeline(fieldOperationHandlers, fieldValidators, treeTransformers, treeValidators
                , contextService, executionConfig);
    }

    @Bean
    public ExpTreeValidator expTreeValidator(List<FieldValidator<Object>> fieldValidators, ProfileFetcher profileFetcher) {
        return new ExpTreeValidatorImpl(fieldValidators, profileFetcher);
    }

    @Bean
    public ExpTreeValidator rangeValidator(@Value("${xplat.oqsengine.sdk.strict.range:true}") boolean isStrict) {
        return new ExpRangeValidator(isStrict);
    }

    @Bean
    public FieldOperationHandler booleanOperationHandler(){
        return new BooleanFieldOperationHandler();
    }

    @Bean
    public FieldValidator regex(SdkConfiguration sdkConfiguration) {
        return new RegexValidator(sdkConfiguration.getValidators());
    }

    @Bean
    public FieldValidator required(SdkConfiguration sdkConfiguration) {
        return new RequiredValidator(sdkConfiguration.getValidators());
    }
    
    @Bean
    public FieldValidator typedCheck(SdkConfiguration sdkConfiguration) {
        return new TypeCheckValidator(sdkConfiguration.getValidators());
    }

    @Bean
    public FieldValidator enumValue(SdkConfiguration sdkConfiguration, DictService dictService) {
        return new EnumValueValidator(sdkConfiguration.getValidators(),dictService);
    }

//    @Bean
//    public FiedValidator editable(SdkConfiguration sdkConfiguration) {
//        return new EditableValidator(sdkConfiguration.getValidators());
//    }

    @Bean
    public MaxLengthValidator maxLengthValidator(SdkConfiguration sdkConfiguration) {
        return new MaxLengthValidator(sdkConfiguration.getValidators());
    }

    @Bean
    public FieldOperationHandler stringsSplitterOperationHandler(SdkConfiguration sdkConfiguration) {
        return new StringsSplitterOperationHandler(sdkConfiguration.getExec().isUseStrictEnum());
    }

    @Bean
    public FieldOperationHandler enumsOperationHandler(SdkConfiguration sdkConfiguration) {
        return new EnumsOperationHandler(sdkConfiguration.getExec().isUseStrictEnum());
    }
    
    @Bean
    public DynamicShiftOperationHandler dynamicShiftOperationHandler() {
        return new DynamicShiftOperationHandler();
    }

    @Bean
    public FieldOperationHandler defaultField() {
        return new DefaultFieldOperationHandler();
    }

    @Bean
    public FieldOperationHandler defaultValueField() {
        return new DefaultFieldValueOperationHandler();
    }

    @Bean
    public FieldOperationHandler defaultSystemField(ContextService contextService, @Value("${xplat.oqsengine.sdk.override:false}") Boolean isOverride) {
        return new FixedDefaultSystemOperationHandler(contextService, isOverride);
    }

    @Bean
    public PreciseEnsureFieldOperationHandler preciseEnsureFieldOperationHandler() {
        return new PreciseEnsureFieldOperationHandler();
    }
    
    @Bean
    public FieldOperationHandler removeId(){
        return new RemoveZeroOperationHandler();
    }

    @Bean
    public FieldOperationHandler typedConvertToString(DictService dictService){
        return new TypeConvertOperationHandler(dictService);
    }

    @Bean
    public FieldOperationHandler simpleExpressionFieldOperationHandler(ContextService contextService) {
        return new SimpleExpressionFieldOperationHandler(contextService);
    }

    @Bean
    public FieldOperationHandler anotherSimpleExpressionFieldOperationHandler(ContextService contextService) {
        return new AnotherSimpleExpressionFieldOperationHandler(contextService);
    }

    @Bean
    public FieldOperationHandler stringDateFormatter(ExecutionConfig executionConfig) {
        List<String> dateFormatters = executionConfig.getDateFormatters();
        if(dateFormatters == null || dateFormatters.isEmpty()) {
            dateFormatters = Collections.singletonList("yyyy-MM-dd HH:mm:ss");
        }

        return new StringToDateTimeOperationHandler(dateFormatters);
    }
    
    @Bean
    public Object register(EventEngine eventEngine, ApplicationContext context) {
        return new SmartInitializingSingleton() {

            @Override
            public void afterSingletonsInstantiated() {
                Map<String, Refreshable> beansOfType = context.getBeansOfType(Refreshable.class);
                beansOfType.values().forEach(x -> {
                    eventEngine.register(UltramanLifecycle.METADATA_REFRESHED, x);
                });
            }
        };
    }
}
