package com.xforceplus.ultraman.starter.autoconfigure;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.math.BigDecimal;

import static com.fasterxml.jackson.databind.ser.std.NumberSerializer.bigDecimalAsStringSerializer;

@Configuration
public class WebCustomAutoConfiguration implements WebMvcConfigurer, InitializingBean {

    @Autowired(required = false)
    private ObjectMapper obj;
    private SimpleModule getSimpleModule() {
        /**
         * 序列换成Json时,将所有的Long变成String
         * 因为js中得数字类型不能包括所有的java Long值
         * WARNING: 前端需要保持字符串。不要輸出非字符串類型
         */
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, ToStringSerializer.instance);
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer<BigDecimal>)bigDecimalAsStringSerializer());
        return simpleModule;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (obj != null) {
            obj.enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
            SimpleModule simpleModule = getSimpleModule();
            obj.registerModule(simpleModule);
        }
    }
}