package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.utils.MetadataEngineHolder;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.calcite.UltramanSchema;
import com.xforceplus.ultraman.sdk.core.calcite.UltramanSchemaFactory;
import com.xforceplus.ultraman.sdk.core.calcite.hints.HintTools;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.proxy.ProxyConnection;
import com.xforceplus.ultraman.sdk.core.calcite.type.ExtendedRelDataTypeSystem;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.api.ProfileFetcher;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.sdk.invocation.invoke.InvocationManager;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.calcite.jdbc.CalciteJdbc41Factory;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

import static com.xforceplus.metadata.schema.dsl.Step.APP;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.LABEL_INDEX;

@Slf4j
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.enabled", matchIfMissing = true)
@Configuration
public class ConnectionAutoConfiguration {

    /**
     * @param metadataEngine
     * @param classEngine
     * @param queryProvider
     * @return
     */
    @Lazy
    @Bean
    public FrameworkConfig frameworkConfig(MetadataEngine metadataEngine, EntityClassEngine classEngine, DataQueryProvider queryProvider
            , ProfileFetcher fetcher, ContextService contextService, InvocationManager invocationManager, EventEngine engine) {

        CalciteSchema configSchema = CalciteSchema.createRootSchema(true, true);
        engine.register(UltramanLifecycle.METADATA_REFRESHED, new Refreshable() {
            @Override
            public void onRefresh(Object payload) {
                configSchema.setCache(false);
                configSchema.setCache(true);
                configSchema.getSubSchemaMap().forEach((name, schema) -> {
                    if(schema != null) {
                        try {
                            schema.setCache(false);
                            schema.setCache(true);
                        } catch (Throwable throwable) {
                            log.warn("", throwable);
                        }
                    }
                });
            }
        });
        
        SchemaPlus rootSchema = configSchema.plus();
        List<Map<String, Object>> appList = metadataEngine.getMulti(__.has(LABEL_INDEX, APP));

        appList.forEach(x -> {
            String code = x.get("code").toString();
            UltramanSchema ultramanSchema = new UltramanSchema(code, MetadataEngineHolder.get()
                    , classEngine, queryProvider, invocationManager, fetcher, contextService, engine);
            rootSchema.add(code, ultramanSchema);
        });

        SqlParser.Config insensitiveParser = SqlParser.configBuilder()
                .setCaseSensitive(false)
                .build();

        FrameworkConfig config = Frameworks.newConfigBuilder()
                .parserConfig(insensitiveParser)
                .defaultSchema(rootSchema)
                .typeSystem(new ExtendedRelDataTypeSystem())
//                .context(new Context() {
//                    @Override
//                    public <C> C unwrap(Class<C> aClass) {
//                        if (aClass == RelBuilder.Config.class) {
//                            return (C) RelBuilder.Config.DEFAULT.withSimplify(false);
//                        } else {
//                            return null;
//                        }
//                    }
//                })
                .sqlToRelConverterConfig(SqlToRelConverter.config()
                        .withHintStrategyTable(HintTools.HINT_STRATEGY_TABLE)
                        .withInSubQueryThreshold(5000))
                .build();

        //warm up!!!!
        RelBuilder relBuilder = RelBuilder.create(config);
        return config;
    }

    @Lazy
    @Primary
    @Bean(name = "CalciteDS")
    public DataSource ultramanConnection(MetadataEngine metadataEngine, EntityClassEngine entityClassEngine, DataQueryProvider dataQueryProvider
            , ProfileFetcher fetcher, ContextService contextService, ExecutionConfig executionConfig, InvocationManager invocationManager, EventEngine eventEngine) throws SQLException {

        //Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        // Get Calcite-specific connection object
        //CalciteConnection calciteConn = connection.unwrap(CalciteConnection.class);
        CalciteSchema rootSchema = CalciteSchema.createRootSchema(true, false);

        /**
         * TODO create schema
         */
        UltramanSchemaFactory factory = new UltramanSchemaFactory(metadataEngine, entityClassEngine, dataQueryProvider
                , eventEngine
                , invocationManager, fetcher, contextService);
//        Schema schema = factory.create(rootSchema.plus(), "", Collections.emptyMap());
//        rootSchema.add("", schema);

        CalciteJdbc41Factory calciteJdbc41Factory = new CalciteJdbc41Factory();
        Properties info = new Properties();
        info.setProperty("caseSensitive", "false");
        info.setProperty("lex", "MYSQL");
        info.setProperty("conformance", "MYSQL_5");
        HikariConfig config = new HikariConfig();
        
        config.setDataSource(new DataSource() {

            @Override
            public Connection getConnection() {
                CalciteSchema rootSchema = CalciteSchema.createRootSchema(true, false);
                Schema schema = factory.create(rootSchema.plus(), "", Collections.emptyMap());
                rootSchema.add("", schema);
                Connection connection = calciteJdbc41Factory.newConnection(new Driver(), calciteJdbc41Factory, "jdbc:calcite:", info, rootSchema, null);
                log.debug("Create Calcite new connection");
                return new ProxyConnection(connection);
            }

            @Override
            public Connection getConnection(String username, String password) throws SQLException {
                return getConnection();
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return false;
            }

            @Override
            public PrintWriter getLogWriter() throws SQLException {
                return null;
            }

            @Override
            public void setLogWriter(PrintWriter out) throws SQLException {

            }

            @Override
            public void setLoginTimeout(int seconds) throws SQLException {

            }

            @Override
            public int getLoginTimeout() throws SQLException {
                return 0;
            }

            @Override
            public Logger getParentLogger() throws SQLFeatureNotSupportedException {
                return null;
            }
        });

      
        config.setMaximumPoolSize(executionConfig.getMaxConnection());
        config.setMaxLifetime(0);
        config.setKeepaliveTime(0);
        HikariDataSource dataSource = new HikariDataSource(config);
        return dataSource;
    }
}
