package com.xforceplus.ultraman.starter.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnProperty(value = "xplat.oqsengine.sdk.cors.enabled", matchIfMissing = true)
@Configuration
public class CorsAutoConfiguration implements WebMvcConfigurer {

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**" )
                .allowedOriginPatterns("*")
                .allowedMethods("GET" , "POST" , "DELETE" , "PUT" , "PATCH" )
                .allowCredentials(true)
                .maxAge(3600);
    }
}
