package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.ultraman.sdk.core.event.impl.LocalEventPublisher;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRegexChecked;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRegexCheckedConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRequiredConfig;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.sdk.infra.event.impl.EventEngineImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
public class EventConfiguration {

    @Bean
    public EventEngine refreshableFactory(EventPublisher eventPublisher) {
        EventEngine eventEngine = new EventEngineImpl(eventPublisher);
        return eventEngine;
    }

    @ConditionalOnMissingBean(EventPublisher.class)
    @Bean
    public EventPublisher localEventPublisher(ApplicationEventPublisher publisher) {
        return new LocalEventPublisher(publisher);
    }

    @ConditionalOnProperty("xplat.elasticsearch.enabled")
    @Bean
    public DynamicRequiredConfig dynamicRequiredConfig() {
        return new DynamicRequiredConfig();
    }

    @ConditionalOnProperty("xplat.elasticsearch.enabled")
    @Bean
    public DynamicRegexCheckedConfig dynamicRegexCheckedConfig() {
        return new DynamicRegexCheckedConfig();
    }
}