package com.xforceplus.ultraman.starter.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.config.ExportConfig;
import com.xforceplus.ultraman.sdk.core.config.ClusterConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.index.IndexConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.ValidatorConfig;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.invocation.invoke.config.InvocationConfig;
import org.springframework.beans.factory.InitializingBean;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.*;

import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 * a global setting for sdk
 */
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.enabled", matchIfMissing = true)
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "xplat.oqsengine.sdk")
@Configuration
public class SdkConfiguration implements InitializingBean {

    @Autowired
    private ObjectMapper mapper;
    
    @Autowired
    private Environment environment;
    
    /**
     * auth:
     * tenant
     * appId
     * branch
     * role
     * env
     */
    private AuthConfig auth = new AuthConfig();
    
    private InvocationConfig invocation = new InvocationConfig();

    private DynamicConfig dynamic = new DynamicConfig();

    private IndexConfig index = new IndexConfig();

    private CdcConfig cdc = new CdcConfig();

    private ExecutionConfig exec = new ExecutionConfig();

    private ExportConfig export = new ExportConfig();

    private ValidatorConfig validators = new ValidatorConfig();
    
    private ClusterConfig cluster = new ClusterConfig();

    public ValidatorConfig getValidators() {
        return validators;
    }

    public void setValidators(ValidatorConfig validators) {
        this.validators = validators;
    }

    public AuthConfig getAuth() {
        return auth;
    }

    public void setAuth(AuthConfig auth) {
        this.auth = auth;
    }

    public ExecutionConfig getExec() {
        return exec;
    }

    public void setExec(ExecutionConfig exec) {
        this.exec = exec;
    }

    public ExportConfig getExport() {
        return export;
    }

    public void setExport(ExportConfig export) {
        this.export = export;
    }

    public ClusterConfig getCluster() {
        return cluster;
    }

    public void setCluster(ClusterConfig cluster) {
        this.cluster = cluster;
    }

    public DynamicConfig getDynamic() {
        return dynamic;
    }

    public void setDynamic(DynamicConfig dynamic) {
        checkDynamic(dynamic);
        this.dynamic = dynamic;
    }

    public InvocationConfig getInvocation() {
        return invocation;
    }

    public void setInvocation(InvocationConfig invocation) {
        this.invocation = invocation;
    }

    private void checkDynamic(DynamicConfig dynamicConfig) {
        Map<String, String> masterRouting = dynamicConfig.getMasterRouting();
        if(!masterRouting.keySet().isEmpty()) {
            Map<String, String> indexRouting = dynamicConfig.getIndexRouting();
            Set<String> indexRelated = indexRouting.keySet();
            boolean isAllMatch = indexRelated.containsAll(masterRouting.keySet());
            if(!isAllMatch) {
                throw new RuntimeException("tenant config is not ok due to index store not contains the master store tenant");
            }
        }
    }

    public IndexConfig getIndex() {
        return index;
    }

    public void setIndex(IndexConfig index) {
        this.index = index;
    }

    public CdcConfig getCdc() {
        return cdc;
    }

    public void setCdc(CdcConfig cdc) {
        this.cdc = cdc;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        try{
            String property = environment.getProperty("xplat.oqsengine.sdk.auth.env");
            String realProperty = property;
            if("fat".equalsIgnoreCase(property)) {
                realProperty = "1";
            } else if("sit".equalsIgnoreCase(property)) {
                realProperty = "3";
            } else if("dev".equalsIgnoreCase(property)) {
                realProperty = "0";
            } else if("prod".equalsIgnoreCase(property)) {
                realProperty = "2";
            }
            
            if(!realProperty.equalsIgnoreCase(property)) {
                Properties properties = new Properties();
                properties.setProperty("xplat.oqsengine.sdk.auth.env", realProperty);
                ((AbstractEnvironment) environment).getPropertySources().addFirst(new PropertiesPropertySource("inmem", properties));
            }
        } catch (Throwable throwable) {
            
        }
    }
}
