/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.starter.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.config.ExportConfig;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.index.IndexConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.ValidatorConfig;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.invocation.invoke.config.InvocationConfig;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties
@ConfigurationProperties(prefix="xplat.oqsengine.sdk")
@Configuration
public class SdkConfiguration
implements InitializingBean {
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private Environment environment;
    private AuthConfig auth = new AuthConfig();
    private InvocationConfig invocation = new InvocationConfig();
    private DynamicConfig dynamic = new DynamicConfig();
    private IndexConfig index = new IndexConfig();
    private CdcConfig cdc = new CdcConfig();
    private ExecutionConfig exec = new ExecutionConfig();
    private ExportConfig export = new ExportConfig();
    private ValidatorConfig validators = new ValidatorConfig();

    public ValidatorConfig getValidators() {
        return this.validators;
    }

    public void setValidators(ValidatorConfig validators) {
        this.validators = validators;
    }

    public AuthConfig getAuth() {
        return this.auth;
    }

    public void setAuth(AuthConfig auth) {
        this.auth = auth;
    }

    public ExecutionConfig getExec() {
        return this.exec;
    }

    public void setExec(ExecutionConfig exec) {
        this.exec = exec;
    }

    public ExportConfig getExport() {
        return this.export;
    }

    public void setExport(ExportConfig export) {
        this.export = export;
    }

    public DynamicConfig getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(DynamicConfig dynamic) {
        this.checkDynamic(dynamic);
        this.dynamic = dynamic;
    }

    public InvocationConfig getInvocation() {
        return this.invocation;
    }

    public void setInvocation(InvocationConfig invocation) {
        this.invocation = invocation;
    }

    private void checkDynamic(DynamicConfig dynamicConfig) {
        Map indexRouting;
        Set indexRelated;
        boolean isAllMatch;
        Map masterRouting = dynamicConfig.getMasterRouting();
        if (!masterRouting.keySet().isEmpty() && !(isAllMatch = (indexRelated = (indexRouting = dynamicConfig.getIndexRouting()).keySet()).containsAll(masterRouting.keySet()))) {
            throw new RuntimeException("tenant config is not ok due to index store not contains the master store tenant");
        }
    }

    public IndexConfig getIndex() {
        return this.index;
    }

    public void setIndex(IndexConfig index) {
        this.index = index;
    }

    public CdcConfig getCdc() {
        return this.cdc;
    }

    public void setCdc(CdcConfig cdc) {
        this.cdc = cdc;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            String property;
            String realProperty = property = this.environment.getProperty("xplat.oqsengine.sdk.auth.env");
            if ("fat".equalsIgnoreCase(property)) {
                realProperty = "1";
            } else if ("sit".equalsIgnoreCase(property)) {
                realProperty = "3";
            } else if ("dev".equalsIgnoreCase(property)) {
                realProperty = "0";
            } else if ("prod".equalsIgnoreCase(property)) {
                realProperty = "2";
            }
            if (!realProperty.equalsIgnoreCase(property)) {
                Properties properties = new Properties();
                properties.setProperty("xplat.oqsengine.sdk.auth.env", realProperty);
                ((AbstractEnvironment)this.environment).getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("inmem", properties));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

