package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.ultraman.sdk.core.event.impl.LocalEventPublisher;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.sdk.infra.event.impl.EventEngineImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
public class EventConfiguration {

    @Bean
    public EventEngine refreshableFactory(List<Refreshable> refreshableList, EventPublisher eventPublisher){
        EventEngine eventEngine = new EventEngineImpl(eventPublisher);
        refreshableList.forEach(x -> {
            eventEngine.register(UltramanLifecycle.METADATA_REFRESHED, x);
        });

        return eventEngine;
    }

    @ConditionalOnMissingBean(EventPublisher.class)
    @Bean
    public EventPublisher localEventPublisher(ApplicationEventPublisher publisher) {
        return new LocalEventPublisher(publisher);
    }
}
