/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.utils.MetadataEngineHolder;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.calcite.UltramanSchema;
import com.xforceplus.ultraman.sdk.core.calcite.UltramanSchemaFactory;
import com.xforceplus.ultraman.sdk.core.calcite.hints.HintTools;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.proxy.ProxyConnection;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.invoke.InvocationManager;
import com.xforceplus.ultraman.sdk.core.invoke.impl.SchemaBasedInvocationManager;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.jdbc.CalciteJdbc41Factory;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class ConnectionAutoConfiguration {
    @Bean
    public InvocationManager manager(ExecutionConfig executionConfig) {
        return new SchemaBasedInvocationManager(executionConfig.getRateLimiter(), executionConfig.getUseCircuitBreaker());
    }

    @Lazy
    @Bean
    public FrameworkConfig frameworkConfig(MetadataEngine metadataEngine, EntityClassEngine classEngine, DataQueryProvider queryProvider, ProfileFetcher fetcher, ContextService contextService, InvocationManager invocationManager) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        List appList = metadataEngine.getMulti((GraphTraversal)__.has((String)"nodeLabel", (Object)"App"));
        appList.forEach(x -> {
            String code = x.get("code").toString();
            UltramanSchema ultramanSchema = new UltramanSchema(code, MetadataEngineHolder.get(), classEngine, queryProvider, invocationManager, fetcher, contextService);
            rootSchema.add(code, (Schema)ultramanSchema);
        });
        SqlParser.Config insensitiveParser = SqlParser.configBuilder().setCaseSensitive(false).build();
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(insensitiveParser).defaultSchema(rootSchema).sqlToRelConverterConfig(SqlToRelConverter.config().withHintStrategyTable(HintTools.HINT_STRATEGY_TABLE)).build();
        RelBuilder relBuilder = RelBuilder.create((FrameworkConfig)config);
        return config;
    }

    @Lazy
    @Bean
    public Connection ultramanConnection(MetadataEngine metadataEngine, EntityClassEngine entityClassEngine, DataQueryProvider dataQueryProvider, ProfileFetcher fetcher, ContextService contextService, InvocationManager invocationManager) throws SQLException {
        Properties info = new Properties();
        info.setProperty("caseSensitive", "false");
        info.setProperty("lex", "MYSQL");
        info.setProperty("conformance", "MYSQL_5");
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false);
        UltramanSchemaFactory factory = new UltramanSchemaFactory(metadataEngine, entityClassEngine, dataQueryProvider, invocationManager, fetcher, contextService);
        Schema schema = factory.create(rootSchema.plus(), "", Collections.emptyMap());
        rootSchema.add("", schema);
        CalciteJdbc41Factory calciteJdbc41Factory = new CalciteJdbc41Factory();
        CalciteJdbc41Factory.CalciteJdbc41Connection connection = calciteJdbc41Factory.newConnection((UnregisteredDriver)new Driver(), (AvaticaFactory)calciteJdbc41Factory, "jdbc:calcite:", info, rootSchema, null);
        return new ProxyConnection((Connection)connection);
    }
}

