/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.starter.autoconfigure;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.utils.MetadataEngineHolder;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.impl.EntityClassEngineImpl;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import com.xforceplus.ultraman.metadata.repository.impl.GraphBasedMetadataRepository;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import java.io.InputStream;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.janusgraph.core.JanusGraph;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.enabled"}, matchIfMissing=true)
public class UltramanMetadataAutoConfiguration {
    @Bean
    public MetadataRepository metadataRepository() {
        return new GraphBasedMetadataRepository();
    }

    @Bean
    public MetadataEngine ultramanMetadataEngine(ExecutionConfig config) throws Exception {
        Settings settings = Settings.read((InputStream)this.getClass().getResourceAsStream("/gremlin-server-configuration.yaml"));
        settings.graphs.put("graph", "inmemory");
        settings.port = config.getMetadataPort();
        ServerGremlinExecutor join = (ServerGremlinExecutor)new GremlinServer(settings).start().join();
        JanusGraph graph = (JanusGraph)join.getGraphManager().getGraph("graph");
        join.getGraphManager().putTraversalSource("g", (TraversalSource)graph.traversal());
        MetadataEngineHolder.graph((JanusGraph)graph);
        MetadataEngineHolder.init();
        return MetadataEngineHolder.get();
    }

    @Bean
    public EntityClassEngine entityClassEngine(MetadataEngine metadataEngine) {
        return new EntityClassEngineImpl(metadataEngine);
    }
}

