/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.storage.config;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tower.storage.StorageFactory;
import com.xforceplus.ultraman.extensions.storage.config.StorageAppIdSupplier;
import com.xforceplus.ultraman.extensions.storage.export.StorageSink;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.ExportSink;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.export.storage-sink", "xplat.oqsengine.sdk.enabled"}, matchIfMissing=false)
@ConditionalOnClass(value={StorageFactory.class})
@Configuration
public class StorageAutoConfiguration {
    @ConditionalOnMissingBean(value={ExportSink.class})
    @ConditionalOnBean(value={StorageAppIdSupplier.class})
    @Bean
    public ExportSink storageFileSink(StorageFactory storageFactory, ContextService contextService, StorageAppIdSupplier storageAppIdSupplier) {
        return new StorageSink(storageFactory, contextService, storageAppIdSupplier.getStorageAppId());
    }

    @ConditionalOnMissingBean(value={StorageAppIdSupplier.class})
    @Bean
    public StorageAppIdSupplier storageAppIdSupplier(@Value(value="${xplat.oqsengine.sdk.export.storageId}") String appId) {
        return () -> appId;
    }
}

