/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.integration.test.framework.extend;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.ConfigFactory;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.config.LocalOqsengineAutoConfiguration;
import com.xforceplus.ultraman.adapter.config.OqsDatasourceAutoConfiguration;
import com.xforceplus.ultraman.adapter.core.impl.AdaptiveDataQueryProvider;
import com.xforceplus.ultraman.adapter.core.impl.LocalDataQueryProvider;
import com.xforceplus.ultraman.adapter.core.impl.LocalEntityFacadeImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.CustomElasticSearchTransport;
import com.xforceplus.ultraman.adapter.elasticsearch.config.UltramanESAutoConfiguration;
import com.xforceplus.ultraman.adapter.elasticsearch.listener.ElasticSearchSdkMetadataListener;
import com.xforceplus.ultraman.adapter.elasticsearch.query.ElasticSearchQueryProvider;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.adatper.ToOneRelatedCallback;
import com.xforceplus.ultraman.adapter.elasticsearch.service.impl.ElasticSearchServiceImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.service.impl.ManageBocpMetadataServiceImpl;
import com.xforceplus.ultraman.cdc.CDCStarter;
import com.xforceplus.ultraman.cdc.adapter.EngineAdapterService;
import com.xforceplus.ultraman.cdc.processor.DataProcessor;
import com.xforceplus.ultraman.cdc.processor.EventQueue;
import com.xforceplus.ultraman.cdc.processor.impl.DefaultDataProcessor;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackage;
import com.xforceplus.ultraman.core.EntityQueryService;
import com.xforceplus.ultraman.core.EntityWriteService;
import com.xforceplus.ultraman.core.impl.EntityQueryServiceImpl;
import com.xforceplus.ultraman.core.impl.EntityWriteServiceImpl;
import com.xforceplus.ultraman.extension.changelog.history.ChangeLogEventListener;
import com.xforceplus.ultraman.extension.changelog.history.ChangelogFacade;
import com.xforceplus.ultraman.extension.changelog.history.HistoryEventListener;
import com.xforceplus.ultraman.extension.changelog.history.impl.DefaultChangelogFacadeImpl;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityCreatedEventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityDeletedEventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityUpdatedEventExtractor;
import com.xforceplus.ultraman.extensions.business.config.BusinessFacadeAutoConfiguration;
import com.xforceplus.ultraman.extensions.business.service.BusinessFacade;
import com.xforceplus.ultraman.extensions.business.service.TenantAwareBusinessFacade;
import com.xforceplus.ultraman.extensions.business.service.impl.TenantAwareBusinessFacadeImpl;
import com.xforceplus.ultraman.extensions.cdc.nested.config.CdcConfiguration;
import com.xforceplus.ultraman.extensions.cdc.status.impl.DBStatusServiceImpl;
import com.xforceplus.ultraman.extensions.reporter.service.NodeReporterService;
import com.xforceplus.ultraman.extensions.reporter.service.impl.DefaultNodeReporterServiceImpl;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.sync.transfer.listener.SdkMetadataListener;
import com.xforceplus.ultraman.metadata.sync.transfer.service.impl.DictServiceImpl;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.ExportSink;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.impl.LocalFileExportSink;
import com.xforceplus.ultraman.sdk.core.bulk.importer.ImportService;
import com.xforceplus.ultraman.sdk.core.bulk.importer.ImportServiceFactory;
import com.xforceplus.ultraman.sdk.core.bulk.importer.ImportTemplateService;
import com.xforceplus.ultraman.sdk.core.bulk.importer.impl.ImportDefaultExcelServiceImpl;
import com.xforceplus.ultraman.sdk.core.bulk.importer.impl.ImportDefaultExcelTemplateServiceImpl;
import com.xforceplus.ultraman.sdk.core.bulk.importer.impl.ImportWizardExcelServiceImpl;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.EventFacade;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.impl.TenantContextProfile;
import com.xforceplus.ultraman.sdk.core.invocation.impl.QueryBasedInvocationManager;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.AnotherSimpleExpressionFieldOperationHandler;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.DefaultFieldValueOperationHandler;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.FixedDefaultSystemOperationHandler;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.SimpleExpressionFieldOperationHandler;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.MaxLengthValidator;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.RequiredValidator;
import com.xforceplus.ultraman.sdk.core.pipeline.query.ExpRangeValidator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.transformer.impl.QueryValueHandlerTransformer;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.base.id.IdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.LongIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.SnowflakeLongIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.StaticNodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.utils.ThreadFactoryHelper;
import com.xforceplus.ultraman.sdk.invocation.invoke.InvocationManager;
import com.xforceplus.ultraman.starter.autoconfigure.ConnectionAutoConfiguration;
import com.xforceplus.ultraman.starter.autoconfigure.EventConfiguration;
import com.xforceplus.ultraman.starter.autoconfigure.UltramanMetadataAutoConfiguration;
import com.xforceplus.ultraman.test.containers.impl.MysqlContainerExtension;
import com.xforceplus.ultraman.test.extend.AbstractUltramanExtension;
import com.xforceplus.ultraman.test.extend.NamedParam;
import com.xforceplus.ultraman.test.extend.TestParameter;
import com.xforceplus.ultraman.transfer.client.BocpClient;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.listener.impl.BocpServerMessageListenerImpl;
import com.xforceplus.ultraman.transfer.client.thread.MessageWorkerManager;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import com.xforceplus.ultraman.transfer.common.event.publisher.EventStream;
import com.xforceplus.ultraman.transfer.common.event.publisher.RxEventStream;
import com.xforceplus.ultraman.transfer.storage.aggregator.properties.BocpTransferStorageProperties;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.AliyunOssStorageStrategy;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.HttpStorageStrategy;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.IStorageStrategy;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.MetadataStorageRepository;
import com.xforceplus.ultraman.transfer.storage.aliyunoss.api.AliyunOssMetadataStorage;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;
import com.xforceplus.ultraman.transfer.storage.http.api.HttpMetadataStorage;
import com.xforceplus.ultraman.transfer.storage.http.interceptor.MetadataHeadInterceptor;
import com.xforceplus.ultraman.transfer.storage.http.token.BocpGatewayTokenClient;
import com.xforceplus.ultraman.transfer.storage.http.token.TokenManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.mockito.Mockito;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.transaction.PlatformTransactionManager;

public class WhiteSdkExtension
extends AbstractUltramanExtension {
    private ActorSystem system = ActorSystem.create();
    private ActorMaterializer mat = ActorMaterializer.create((ActorRefFactory)this.system);
    private Set<Class> supportsParameters = new HashSet<Class>();

    public WhiteSdkExtension() {
        this.supportsParameters.add(EntityFacade.class);
        this.supportsParameters.add(MetadataRepository.class);
        this.supportsParameters.add(EntityClassEngine.class);
        this.supportsParameters.add(BusinessFacade.class);
        this.supportsParameters.add(TenantAwareBusinessFacade.class);
        this.supportsParameters.add(ContextService.class);
        this.supportsParameters.add(EventFacade.class);
        this.supportsParameters.add(DictService.class);
        this.supportsParameters.add(PlatformTransactionManager.class);
        this.supportsParameters.add(EngineAdapterService.class);
        this.supportsParameters.add(ChangelogFacade.class);
        this.supportsParameters.add(ApplicationEventPublisher.class);
        this.supportsParameters.add(HistoryEventListener.class);
        this.supportsParameters.add(ChangeLogEventListener.class);
        this.supportsParameters.add(MetadataEngine.class);
        this.supportsParameters.add(DynamicConfig.class);
        this.supportsParameters.add(EventEngine.class);
        this.supportsParameters.add(BocpClient.class);
        this.supportsParameters.add(NodeReporterService.class);
        this.supportsParameters.add(DataSource.class);
        this.supportsParameters.add(ImportService.class);
        this.supportsParameters.add(ImportServiceFactory.class);
        this.supportsParameters.add(ImportTemplateService.class);
    }

    protected void prepare(TestParameter parameter, ExtensionContext context) {
        ConfigFactory.invalidateCaches();
        String envProfile = Optional.ofNullable(parameter.getValue("env_profile")).orElse("default");
        String appId = parameter.getValue("app_id");
        String env = parameter.getValue("app_env");
        String bocpEnv = parameter.getValue("bocp_env");
        String useCDC = parameter.getValue("cdc");
        String useWaitFor = parameter.getValue("wait_for");
        String mode = parameter.getValue("bocp_use");
        String compat = parameter.getValue("bocp_compat");
        String useEs = parameter.getValue("use_es");
        String queryType = parameter.getValue("query_type");
        mode = Optional.ofNullable(mode).orElse("http");
        compat = Optional.ofNullable(compat).orElse("none");
        boolean useCdc = false;
        if (!StringUtils.isEmpty((String)useCDC)) {
            useCdc = Boolean.parseBoolean(useCDC);
        }
        boolean useWaitForBoolean = false;
        if (!StringUtils.isEmpty((String)useWaitFor)) {
            useWaitForBoolean = Boolean.parseBoolean(useWaitFor);
        }
        boolean useEsBoolean = false;
        if (!StringUtils.isEmpty((String)useEs)) {
            useEsBoolean = Boolean.parseBoolean(useEs);
        }
        Map<Class, Object> sdkContext = null;
        try {
            sdkContext = this.init(envProfile, appId, env, bocpEnv, useCdc, useWaitForBoolean, useEsBoolean, mode, compat, queryType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ExtensionContext.Store whiteStore = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{WhiteSdkExtension.class}));
        if (sdkContext == null) {
            throw new RuntimeException("Cannot init SDK context");
        }
        sdkContext.forEach((k, v) -> whiteStore.put(k, v));
    }

    private void set(Object origin, String value, Object obj) {
        Field field = FieldUtils.getDeclaredField(origin.getClass(), (String)value, (boolean)true);
        field.setAccessible(true);
        try {
            field.set(origin, obj);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private AliyunOssMetadataStorage aliyunOssMetadataStorage(BocpTransferStorageProperties storageProperties) {
        OSS ossClient = new OSSClientBuilder().build(storageProperties.getAliyunossEndpoint(), storageProperties.getAliyunossAccessKey(), storageProperties.getAliyunossSecretKey());
        return new AliyunOssMetadataStorage(ossClient);
    }

    protected Map<Class, Object> init(String profile, String appId, String env, String bocpEnv, boolean useCdc, boolean useWaitFor, boolean useEs, String mode, String bocpCompat, String queryType) throws Exception {
        HttpStorageStrategy storageStrategy;
        ActorSystem actorSystem = ActorSystem.create();
        ActorMaterializer actorMaterializer = ActorMaterializer.create((ActorRefFactory)actorSystem);
        ContextService contextService = this.contextService();
        TenantContextProfile fetcher = new TenantContextProfile(contextService);
        MockEnvironment environment = new MockEnvironment();
        environment.setActiveProfiles(new String[]{profile});
        BocpClient client = null;
        BocpClientSetting bocpClientSetting = new BocpClientSetting();
        OqsSdkProperties properties = new OqsSdkProperties();
        OqsSdkProperties.AuthConfig authConfig = new OqsSdkProperties.AuthConfig();
        authConfig.setAppId(appId);
        authConfig.setEnv(env);
        properties.setAuth(authConfig);
        EventConfiguration eventConfiguration = new EventConfiguration();
        DynamicConfig dynamicConfig = new DynamicConfig();
        ApplicationEventPublisher mockSpringPublisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        EventPublisher eventPublisher = eventConfiguration.localEventPublisher(mockSpringPublisher);
        EventEngine eventEngine = eventConfiguration.refreshableFactory(eventPublisher);
        BocpTransferStorageProperties storageProperties = new BocpTransferStorageProperties();
        if (mode.equals("http")) {
            IMetadataStorage metadataStorage = this.httpMetadataStorage(bocpEnv);
            storageStrategy = new HttpStorageStrategy(metadataStorage);
        } else if (mode.equals("oss")) {
            AliyunOssMetadataStorage metadataStorage = this.aliyunOssMetadataStorage(storageProperties);
            storageStrategy = new AliyunOssStorageStrategy((IMetadataStorage)metadataStorage);
        } else {
            throw new RuntimeException("Mode is not Supported");
        }
        MetadataStorageRepository storageRepository = new MetadataStorageRepository((IStorageStrategy)storageStrategy);
        MessageWorkerManager manager = new MessageWorkerManager();
        manager.init();
        RxEventStream eventEventStream = new RxEventStream();
        BocpServerMessageListenerImpl bocpServerMessageListener = new BocpServerMessageListenerImpl(bocpClientSetting, properties, storageRepository, manager, (EventStream)eventEventStream);
        BocpClientSetting.Bocp bocp = new BocpClientSetting.Bocp();
        if (bocpEnv.equals("dev")) {
            bocp.setHost("ultraman-t.xforcecloud.com/bocp");
            bocp.setUseSsl(true);
            bocp.setPort("80");
        } else {
            bocp.setHost("ultraman.xforcecloud.com/bocp");
            bocp.setUseSsl(true);
            bocp.setPort("80");
        }
        if ("1.6".equals(bocpCompat)) {
            bocp.setEnableSDKConfig(Boolean.valueOf(false));
        }
        bocpClientSetting.setBocp(bocp);
        client = new BocpClient(bocpClientSetting, properties, Collections.singletonList(bocpServerMessageListener));
        UltramanMetadataAutoConfiguration metadataAutoConfiguration = new UltramanMetadataAutoConfiguration();
        metadataAutoConfiguration.metadataRepository();
        MetadataEngine metadataEngine = metadataAutoConfiguration.ultramanMetadataEngine(this.executionConfig());
        EntityClassEngine entityClassEngine = metadataAutoConfiguration.entityClassEngine(metadataEngine);
        OqsDatasourceAutoConfiguration oqsDatasourceAutoConfiguration = new OqsDatasourceAutoConfiguration();
        DataSource dataSource = oqsDatasourceAutoConfiguration.dynamicDataSource((ProfileFetcher)fetcher, contextService, dynamicConfig, (Environment)environment, this.executionConfig());
        CdcConfig cdcConfig = new CdcConfig();
        EngineAdapterService noOp = null;
        if (useCdc) {
            this.clearFile("src/test/resource/cdc_luye");
            ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{MysqlContainerExtension.class});
            CdcConfiguration cdcConfiguration = new CdcConfiguration();
            CDCPropertyPackage cdcPropertyPackage = cdcConfiguration.cdcPropertyPackage((Environment)environment);
            DataProcessor dataProcessor = cdcConfiguration.dataProcessor(cdcConfig);
            DefaultDataProcessor defaultDataProcessor = (DefaultDataProcessor)dataProcessor;
            ((DefaultDataProcessor)dataProcessor).setEventThreadPool(ThreadFactoryHelper.buildThreadPool((int)10, (int)1000, (String)"event", (boolean)false));
            EventQueue eventQueue = cdcConfiguration.cdcEventQueue();
            noOp = (EngineAdapterService)Mockito.mock(EngineAdapterService.class);
            ToOneRelatedCallback oneRelatedCallback = new ToOneRelatedCallback();
            oneRelatedCallback.setDataSource(dataSource);
            oneRelatedCallback.setEngine(entityClassEngine);
            oneRelatedCallback.setContextService(contextService);
            defaultDataProcessor.setCdcBeforeCallbacks(Arrays.asList(oneRelatedCallback));
            defaultDataProcessor.setEventQueue(eventQueue);
            defaultDataProcessor.setPublisher(eventPublisher);
            defaultDataProcessor.setEngineAdapterService(noOp);
            if (useWaitFor) {
                ExecutorService executorService = ThreadFactoryHelper.buildThreadPool((int)10, (int)100, (String)"test", (boolean)false);
                DBStatusServiceImpl statusService = new DBStatusServiceImpl(executorService, dataSource, 30, false);
                statusService.setLongIdGenerator((LongIdGenerator)new SnowflakeLongIdGenerator((NodeIdGenerator)new StaticNodeIdGenerator(1)));
                statusService.setMainJdbcTemplate(new JdbcTemplate(dataSource));
            } else {
                defaultDataProcessor.setStatusService(null);
            }
            defaultDataProcessor.setEngine(entityClassEngine);
            CDCStarter cdcStarter = cdcConfiguration.cdcStarter(cdcConfig, cdcPropertyPackage, dataProcessor, null);
            cdcStarter.init();
        }
        GlobalInited globalInited = new GlobalInited(Integer.valueOf(10), Integer.valueOf(10));
        SdkMetadataListener listener = new SdkMetadataListener(metadataEngine, globalInited, eventEngine, mockSpringPublisher, (Environment)environment, Collections.emptyList());
        eventEventStream.subscribe(arg_0 -> ((SdkMetadataListener)listener).onApplicationEvent(arg_0));
        LocalEntityFacadeImpl entityFacade = new LocalEntityFacadeImpl();
        TransformerPipeline pipeline = this.pipeline(contextService);
        ConnectionAutoConfiguration configuration = new ConnectionAutoConfiguration();
        LocalOqsengineAutoConfiguration oqsengineAutoConfiguration = new LocalOqsengineAutoConfiguration();
        ExecutorService executorService = ThreadFactoryHelper.buildThreadPool((int)10, (int)10, (String)"common", (boolean)false);
        DataSourceTransactionManager manager1 = new DataSourceTransactionManager(dataSource);
        LocalDataQueryProvider dataQueryProvider = null;
        DictServiceImpl dictService = new DictServiceImpl(contextService, metadataEngine);
        MasterStorage masterStorage = oqsengineAutoConfiguration.masterStorage(dataSource, new ObjectMapper(), entityClassEngine, this.executionConfig(), (PlatformTransactionManager)manager1, cdcConfig, (DictService)dictService, 1000L, 1000L);
        EntityWriteServiceImpl entityWriteService = new EntityWriteServiceImpl(masterStorage, entityClassEngine);
        ArrayList dataQueryProviders = new ArrayList();
        if ("adaptive".equalsIgnoreCase(queryType)) {
            AdaptiveDataQueryProvider adaptiveDataQueryProvider = new AdaptiveDataQueryProvider(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (useEs) {
            UltramanESAutoConfiguration ultramanESAutoConfiguration = new UltramanESAutoConfiguration();
            TransportExecutor transportExecutor = ultramanESAutoConfiguration.transportExecutor(dynamicConfig, (Environment)environment);
            ElasticSearchServiceImpl indexOperation = new ElasticSearchServiceImpl(3, 0, 20, 3, 8, false);
            indexOperation.setBeforeCallBacks(Collections.emptyList());
            indexOperation.setFilters(Collections.emptyList());
            indexOperation.setDynamicConfig(dynamicConfig);
            indexOperation.setEntityClassEngine(entityClassEngine);
            indexOperation.setElasticsearchTransportExecutor(transportExecutor);
            ManageBocpMetadataService manageBocpMetadataService = ultramanESAutoConfiguration.manageBocpMetadataService();
            ManageBocpMetadataServiceImpl manageBocpMetadataServiceImpl = (ManageBocpMetadataServiceImpl)manageBocpMetadataService;
            manageBocpMetadataServiceImpl.setApplicationContext(null);
            manageBocpMetadataServiceImpl.setDynamicConfig(dynamicConfig);
            CustomElasticSearchTransport customElasticSearchTransport = ultramanESAutoConfiguration.customElasticSearchTransport(dynamicConfig, transportExecutor);
            manageBocpMetadataServiceImpl.setCustomElasticSearchTransport(customElasticSearchTransport);
            manageBocpMetadataServiceImpl.setEntityClassEngine(entityClassEngine);
            ElasticSearchQueryProvider elasticSearchQueryProvider = new ElasticSearchQueryProvider();
            DataSource esDataSource = ultramanESAutoConfiguration.esConnection(transportExecutor, metadataEngine, entityClassEngine, contextService, (ProfileFetcher)fetcher, this.executionConfig(), dynamicConfig, manageBocpMetadataService);
            elasticSearchQueryProvider.setEsDataSource(esDataSource);
            elasticSearchQueryProvider.setExecutionConfig(this.executionConfig());
            elasticSearchQueryProvider.setContextService(contextService);
            elasticSearchQueryProvider.setEngine(entityClassEngine);
            ElasticSearchSdkMetadataListener es = new ElasticSearchSdkMetadataListener();
            es.setManageBocpMetadataService(manageBocpMetadataService);
            ((ApplicationEventPublisher)Mockito.doAnswer(invocationOnMock -> {
                Object argument = invocationOnMock.getArgument(0);
                if (argument instanceof SDKMetadataEvent) {
                    es.onApplicationEvent((SDKMetadataEvent)argument);
                }
                return null;
            }).when((Object)mockSpringPublisher)).publishEvent(Mockito.any(SDKMetadataEvent.class));
            listener.afterSingletonsInstantiated();
            dataQueryProvider = elasticSearchQueryProvider;
        } else {
            LocalDataQueryProvider localDataQueryProvider;
            EntityQueryServiceImpl entityQueryService = new EntityQueryServiceImpl(masterStorage, entityClassEngine);
            dataQueryProvider = localDataQueryProvider = new LocalDataQueryProvider((EntityQueryService)entityQueryService, contextService);
        }
        QueryBasedInvocationManager invocationManager = new QueryBasedInvocationManager(this.executionConfig());
        FrameworkConfig config = configuration.frameworkConfig(metadataEngine, entityClassEngine, (DataQueryProvider)dataQueryProvider, (ProfileFetcher)fetcher, contextService, (InvocationManager)invocationManager, eventEngine);
        DataSource calciteDS = configuration.ultramanConnection(metadataEngine, entityClassEngine, (DataQueryProvider)dataQueryProvider, (ProfileFetcher)fetcher, contextService, this.executionConfig(), (InvocationManager)invocationManager, eventEngine);
        entityFacade.setConfig(config);
        entityFacade.setAuthBuilder(null);
        entityFacade.setDataSource(calciteDS);
        entityFacade.setEngine(entityClassEngine);
        entityFacade.setFetcher((ProfileFetcher)fetcher);
        entityFacade.setWriteService((EntityWriteService)entityWriteService);
        entityFacade.setTransformerPipeline(pipeline);
        entityFacade.setContextService(contextService);
        entityFacade.setIdGenerator((IdGenerator)new SnowflakeLongIdGenerator((NodeIdGenerator)new StaticNodeIdGenerator(0)));
        BusinessFacadeAutoConfiguration businessFacadeAutoConfiguration = new BusinessFacadeAutoConfiguration();
        BusinessFacade businessFacade = businessFacadeAutoConfiguration.businessFacade((EntityFacade)entityFacade, entityClassEngine, (ProfileFetcher)fetcher, this.executionConfig(), contextService);
        DefaultChangelogFacadeImpl changelogFacade = new DefaultChangelogFacadeImpl(dataSource, entityClassEngine, new ObjectMapper());
        HistoryEventListener eventListener = new HistoryEventListener(this.mat);
        eventListener.setDataSource(dataSource);
        eventListener.setEngine(entityClassEngine);
        ChangeLogEventListener changeLogEventListener = new ChangeLogEventListener(this.mat, entityClassEngine);
        changeLogEventListener.setDataSource(dataSource);
        EntityCreatedEventExtractor createdEventExtractor = new EntityCreatedEventExtractor();
        EntityUpdatedEventExtractor updateEventExtractor = new EntityUpdatedEventExtractor();
        EntityDeletedEventExtractor deletedEventExtractor = new EntityDeletedEventExtractor();
        changeLogEventListener.setEventExtractors(Arrays.asList(createdEventExtractor, updateEventExtractor, deletedEventExtractor));
        TenantAwareBusinessFacadeImpl tenantAwareBusinessFacade = new TenantAwareBusinessFacadeImpl((EntityFacade)entityFacade, entityClassEngine, (ProfileFetcher)fetcher, contextService, this.executionConfig());
        AuthConfig sdkAuthConfig = new AuthConfig();
        sdkAuthConfig.setAppId(authConfig.getAppId());
        sdkAuthConfig.setEnv(authConfig.getEnv());
        DefaultNodeReporterServiceImpl nodeReporterService = new DefaultNodeReporterServiceImpl(sdkAuthConfig, "demo-test", entityClassEngine);
        LocalFileExportSink sink = new LocalFileExportSink("./");
        ImportWizardExcelServiceImpl importWizardExcelService = new ImportWizardExcelServiceImpl((EntityFacade)entityFacade, contextService, executorService, (IdGenerator)new SnowflakeLongIdGenerator((NodeIdGenerator)new StaticNodeIdGenerator(1)), eventPublisher, (ExportSink)sink, this.mat);
        ImportDefaultExcelServiceImpl importDefaultExcelService = new ImportDefaultExcelServiceImpl((EntityFacade)entityFacade, contextService, executorService, eventPublisher);
        ImportDefaultExcelTemplateServiceImpl importTemplateService = new ImportDefaultExcelTemplateServiceImpl((EntityFacade)entityFacade, contextService, (ExportSink)sink, this.mat, executorService);
        ImportServiceFactory importServiceFactory = new ImportServiceFactory(Arrays.asList(importWizardExcelService, importDefaultExcelService));
        HashMap<Class, Object> context = new HashMap<Class, Object>();
        context.put(BusinessFacade.class, businessFacade);
        context.put(EntityClassEngine.class, entityClassEngine);
        context.put(PlatformTransactionManager.class, manager1);
        context.put(EngineAdapterService.class, noOp);
        context.put(ChangelogFacade.class, changelogFacade);
        context.put(ApplicationEventPublisher.class, mockSpringPublisher);
        context.put(HistoryEventListener.class, eventListener);
        context.put(ChangeLogEventListener.class, changeLogEventListener);
        context.put(MetadataEngine.class, metadataEngine);
        context.put(DynamicConfig.class, dynamicConfig);
        context.put(EventEngine.class, eventEngine);
        context.put(BocpClient.class, client);
        context.put(ContextService.class, contextService);
        context.put(TenantAwareBusinessFacade.class, tenantAwareBusinessFacade);
        context.put(NodeReporterService.class, nodeReporterService);
        context.put(ImportService.class, importDefaultExcelService);
        context.put(ImportTemplateService.class, importTemplateService);
        context.put(ImportServiceFactory.class, importServiceFactory);
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        dataSourceMap.put("calciteDS", calciteDS);
        context.put(DataSource.class, dataSourceMap);
        return context;
    }

    private void clearFile(String s) throws IOException {
        File file = new File(s);
        if (file.exists()) {
            FileUtils.deleteDirectory((File)file);
        }
    }

    private IMetadataStorage httpMetadataStorage(String env) {
        String secret;
        String authUrl;
        String baseUrl;
        String apiPrefix = "api/global/bocp";
        String clientId = "tg_ultraman_auth";
        if (env.equalsIgnoreCase("dev")) {
            baseUrl = "ultraman-t.xforcecloud.com/bocp";
            authUrl = "https://paas-t.xforceplus.com";
            secret = "0QHOcifR1";
        } else {
            baseUrl = "ultraman.xforcecloud.com/bocp";
            authUrl = "https://paas-s.xforceplus.com";
            secret = "YVFY1q123Blp9c";
        }
        BocpGatewayTokenClient client = new BocpGatewayTokenClient(authUrl, clientId, secret);
        TokenManager tokenManager = new TokenManager(client);
        MetadataHeadInterceptor metadataHeadInterceptor = new MetadataHeadInterceptor(tokenManager);
        return new HttpMetadataStorage(baseUrl, Boolean.valueOf(true), apiPrefix, metadataHeadInterceptor);
    }

    private AuthConfig authConfig(String appId, String env) {
        AuthConfig authConfig = new AuthConfig();
        authConfig.setAppId(appId);
        authConfig.setEnv(env);
        return authConfig;
    }

    protected ContextService contextService() {
        final ConcurrentHashMap map = new ConcurrentHashMap();
        ContextService contextService = new ContextService(){

            public <T> void set(ContextService.ContextKey<T> contextKey, T t) {
                if (t == null) {
                    map.remove(contextKey.name());
                } else {
                    map.put(contextKey.name(), t);
                }
            }

            public <T> T get(ContextService.ContextKey<T> contextKey) {
                return (T)map.get(contextKey.name());
            }

            public Map<String, Object> getAll() {
                return map;
            }

            public void fromMap(Map<String, Object> map2) {
                map2.putAll(map2);
            }

            public void clear() {
                map.clear();
            }
        };
        return contextService;
    }

    protected ExecutorService executionService() {
        return Executors.newFixedThreadPool(10);
    }

    protected TransformerPipeline pipeline(ContextService service) {
        LinkedList<Object> fieldOperationHandlers = new LinkedList<Object>();
        fieldOperationHandlers.add(new DefaultFieldValueOperationHandler());
        fieldOperationHandlers.add(new FixedDefaultSystemOperationHandler(service, false));
        MaxLengthValidator maxLengthValidator = new MaxLengthValidator();
        RequiredValidator requiredValidator = new RequiredValidator();
        LinkedList<Object> fieldValidators = new LinkedList<Object>();
        fieldValidators.add(maxLengthValidator);
        fieldValidators.add(requiredValidator);
        LinkedList<QueryValueHandlerTransformer> treeTransformers = new LinkedList<QueryValueHandlerTransformer>();
        treeTransformers.add(new QueryValueHandlerTransformer(Arrays.asList(new SimpleExpressionFieldOperationHandler(service), new AnotherSimpleExpressionFieldOperationHandler(service))));
        LinkedList<ExpRangeValidator> treeValidators = new LinkedList<ExpRangeValidator>();
        treeValidators.add(new ExpRangeValidator(true));
        TransformerPipeline pipeline = new TransformerPipeline(fieldOperationHandlers, fieldValidators, treeTransformers, treeValidators, service, this.executionConfig());
        return pipeline;
    }

    protected ExecutionConfig executionConfig() {
        ExecutionConfig config = new ExecutionConfig();
        config.setMetadataEnabled(false);
        return config;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        String name = parameterContext.getParameter().getName();
        return this.supportsParameters.contains(type);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ExtensionContext.Store store;
        Object o;
        Class<?> type = parameterContext.getParameter().getType();
        NamedParam annotation = parameterContext.getParameter().getAnnotation(NamedParam.class);
        String name = null;
        if (annotation != null) {
            name = annotation.value();
        }
        if ((o = (store = extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{WhiteSdkExtension.class}))).get(type)) instanceof Map && !StringUtils.isEmpty((String)name)) {
            return ((Map)o).get(name);
        }
        return o;
    }
}

