package com.xforceplus.ultraman.oqsengine.plus.integration.test.framework.extend;

import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.typesafe.config.ConfigFactory;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.config.LocalOqsengineAutoConfiguration;
import com.xforceplus.ultraman.adapter.config.OqsDatasourceAutoConfiguration;
import com.xforceplus.ultraman.adapter.core.impl.LocalDataQueryProvider;
import com.xforceplus.ultraman.adapter.core.impl.LocalEntityFacadeImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.service.adatper.ToOneRelatedCallback;
import com.xforceplus.ultraman.cdc.CDCStarter;
import com.xforceplus.ultraman.cdc.adapter.EngineAdapterService;
import com.xforceplus.ultraman.cdc.processor.DataProcessor;
import com.xforceplus.ultraman.cdc.processor.EventQueue;
import com.xforceplus.ultraman.cdc.processor.impl.DefaultDataProcessor;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackage;
import com.xforceplus.ultraman.core.EntityQueryService;
import com.xforceplus.ultraman.core.EntityWriteService;
import com.xforceplus.ultraman.core.impl.EntityQueryServiceImpl;
import com.xforceplus.ultraman.core.impl.EntityWriteServiceImpl;
import com.xforceplus.ultraman.extension.changelog.history.ChangeLogEventListener;
import com.xforceplus.ultraman.extension.changelog.history.ChangelogFacade;
import com.xforceplus.ultraman.extension.changelog.history.HistoryEventListener;
import com.xforceplus.ultraman.extension.changelog.history.impl.DefaultChangelogFacadeImpl;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityCreatedEventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityDeletedEventExtractor;
import com.xforceplus.ultraman.extension.changelog.history.impl.EntityUpdatedEventExtractor;
import com.xforceplus.ultraman.extensions.business.config.BusinessFacadeAutoConfiguration;
import com.xforceplus.ultraman.extensions.business.service.BusinessFacade;
import com.xforceplus.ultraman.extensions.business.service.TenantAwareBusinessFacade;
import com.xforceplus.ultraman.extensions.business.service.impl.TenantAwareBusinessFacadeImpl;
import com.xforceplus.ultraman.extensions.cdc.nested.config.CdcConfiguration;
import com.xforceplus.ultraman.extensions.cdc.status.impl.DBStatusServiceImpl;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.sync.transfer.listener.SdkMetadataListener;
import com.xforceplus.ultraman.oqsengine.plus.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.EventFacade;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.impl.TenantContextProfile;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.*;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.FieldValidator;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.MaxLengthValidator;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.RequiredValidator;
import com.xforceplus.ultraman.sdk.core.pipeline.query.ExpRangeValidator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.transformer.ExpTreeTransformer;
import com.xforceplus.ultraman.sdk.core.rel.legacy.transformer.impl.QueryValueHandlerTransformer;
import com.xforceplus.ultraman.sdk.core.rel.legacy.validate.ExpTreeValidator;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.base.CdcConfig;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.base.id.SnowflakeLongIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.id.node.StaticNodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.utils.ThreadFactoryHelper;
import com.xforceplus.ultraman.sdk.invocation.invoke.InvocationManager;
import com.xforceplus.ultraman.sdk.invocation.invoke.impl.QueryBasedInvocationManager;
import com.xforceplus.ultraman.starter.autoconfigure.ConnectionAutoConfiguration;
import com.xforceplus.ultraman.starter.autoconfigure.EventConfiguration;
import com.xforceplus.ultraman.starter.autoconfigure.UltramanMetadataAutoConfiguration;
import com.xforceplus.ultraman.test.containers.impl.MysqlContainerExtension;
import com.xforceplus.ultraman.test.extend.AbstractUltramanExtension;
import com.xforceplus.ultraman.test.extend.TestParameter;
import com.xforceplus.ultraman.transfer.client.BocpClient;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.client.listener.impl.BocpServerMessageListenerImpl;
import com.xforceplus.ultraman.transfer.client.thread.MessageWorkerManager;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import com.xforceplus.ultraman.transfer.common.event.publisher.EventStream;
import com.xforceplus.ultraman.transfer.common.event.publisher.RxEventStream;
import com.xforceplus.ultraman.transfer.storage.aggregator.properties.BocpTransferStorageProperties;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.AliyunOssStorageStrategy;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.HttpStorageStrategy;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.IStorageStrategy;
import com.xforceplus.ultraman.transfer.storage.aggregator.strategy.MetadataStorageRepository;
import com.xforceplus.ultraman.transfer.storage.aliyunoss.api.AliyunOssMetadataStorage;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;
import com.xforceplus.ultraman.transfer.storage.http.api.HttpMetadataStorage;
import com.xforceplus.ultraman.transfer.storage.http.interceptor.MetadataHeadInterceptor;
import com.xforceplus.ultraman.transfer.storage.http.token.GatewayTokenClient;
import com.xforceplus.ultraman.transfer.storage.http.token.TokenManager;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.mockito.Mockito;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.transaction.PlatformTransactionManager;

import javax.sql.DataSource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * white sdk
 */
public class WhiteSdkExtension extends AbstractUltramanExtension {

    private ActorSystem system = ActorSystem.create();
    private ActorMaterializer mat = ActorMaterializer.create(system);

    private Set<Class> supportsParameters = new HashSet<>();

    public WhiteSdkExtension() {
        supportsParameters.add(EntityFacade.class);
        supportsParameters.add(MetadataRepository.class);
        supportsParameters.add(EntityClassEngine.class);
        supportsParameters.add(BusinessFacade.class);
        supportsParameters.add(TenantAwareBusinessFacade.class);
        supportsParameters.add(ContextService.class);
        supportsParameters.add(EventFacade.class);
        supportsParameters.add(DictService.class);
        supportsParameters.add(PlatformTransactionManager.class);
        supportsParameters.add(EngineAdapterService.class);
        supportsParameters.add(ChangelogFacade.class);
        supportsParameters.add(ApplicationEventPublisher.class);
        supportsParameters.add(HistoryEventListener.class);
        supportsParameters.add(ChangeLogEventListener.class);
        supportsParameters.add(MetadataEngine.class);
        supportsParameters.add(DynamicConfig.class);
        supportsParameters.add(EventEngine.class);
        supportsParameters.add(BocpClient.class);
    }

    protected void prepare(TestParameter parameter, ExtensionContext context) {

        /**
         * invalidate to reload system properties
         */
        ConfigFactory.invalidateCaches();

        String envProfile = Optional.ofNullable(parameter.getValue(WhiteSdkParameters.ACTIVATE_PROFILE)).orElse("default");
        String appId = parameter.getValue(WhiteSdkParameters.APP_ID);
        String env = parameter.getValue(WhiteSdkParameters.APP_ENV);
        String bocpEnv = parameter.getValue(WhiteSdkParameters.BOCP_ENV);
        String useCDC = parameter.getValue(WhiteSdkParameters.USE_CDC);
        String useWaitFor = parameter.getValue(WhiteSdkParameters.USE_WAIT_FOR);
        String mode = parameter.getValue(WhiteSdkParameters.BOCP_USE);
        String compat = parameter.getValue(WhiteSdkParameters.BOCP_COMPAT);
        mode = Optional.ofNullable(mode).orElse("http");
        compat = Optional.ofNullable(compat).orElse("none");

        boolean useCdc = false;
        if (!StringUtils.isEmpty(useCDC)) {
            useCdc = Boolean.parseBoolean(useCDC);
        }

        boolean useWaitForBoolean = false;
        if (!StringUtils.isEmpty(useWaitFor)) {
            useWaitForBoolean = Boolean.parseBoolean(useWaitFor);
        }

        Map<Class, Object> sdkContext = null;

        try {
            sdkContext = init(
                    envProfile
                    , appId, env, bocpEnv, useCdc, useWaitForBoolean, mode, compat);
        } catch (Exception e) {
            e.printStackTrace();
        }

//        if (StringUtils.isEmpty(realMysqlHost) || StringUtils.isEmpty(realMysqlPort)) {
//
//        }
//        else {
//            if (oqs.startsWith("$") || port.startsWith("$")) {
//                ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create(OqsExtension.class));
//                if (store != null) {
//                    realHost = getValue(oqs.substring(2, oqs.length() - 1), store);
//                    realPort = getValue(port.substring(2, port.length() - 1), store);
//                }
//            }
//            sdkContext = init(realHost, Integer.parseInt(realPort), appId, env, bocpEnv);
//        }

        ExtensionContext.Store whiteStore = context.getStore(ExtensionContext.Namespace.create(WhiteSdkExtension.class));
        if (sdkContext != null) {
            sdkContext.forEach((k, v) -> {
                whiteStore.put(k, v);
            });
        } else {
            throw new RuntimeException("Cannot init SDK context");
        }
    }

//    private String getValue(String spel, ExtensionContext.Store store) {
//        ExpressionParser expressionParser = new SpelExpressionParser();
//        Expression expression = expressionParser.parseExpression(spel);
//
//        //prepare for the oqsengine
//        OqsContainerResource o = (OqsContainerResource) store.get(OqsContainerResource.class);
//
//        Map<String, OqsContainer> oqsContainersMapping = Optional.ofNullable(o).map(x -> x.getOqs())
//                .orElse(Collections.emptyList()).
//                        stream().collect(Collectors.toMap(x -> x.getContainerName(), x -> x, (a, b) -> a));
//
//        EvaluationContext evalContext = new StandardEvaluationContext(oqsContainersMapping);
//
//        return expression.getValue(evalContext).toString();
//    }

    private void set(Object origin, String value, Object obj) {
        Field field = FieldUtils.getDeclaredField(origin.getClass(), value, true);
        field.setAccessible(true);
        try {
            field.set(origin, obj);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private AliyunOssMetadataStorage aliyunOssMetadataStorage(BocpTransferStorageProperties storageProperties) {
        OSS ossClient = new OSSClientBuilder().build(
                storageProperties.getAliyunossEndpoint(),
                storageProperties.getAliyunossAccessKey(),
                storageProperties.getAliyunossSecretKey());
        return new AliyunOssMetadataStorage(ossClient);
    }

    protected Map<Class, Object> init(String profile
            , String appId, String env, String bocpEnv, boolean useCdc, boolean useWaitFor, String mode, String bocpCompat) throws Exception {
        ActorSystem actorSystem = ActorSystem.create();
        ActorMaterializer actorMaterializer = ActorMaterializer.create(actorSystem);

        ContextService contextService = contextService();
        ProfileFetcher fetcher = new TenantContextProfile(contextService);

        MockEnvironment environment = new MockEnvironment();
        environment.setActiveProfiles(profile);

        BocpClient client = null;
        BocpClientSetting bocpClientSetting = new BocpClientSetting();
        

        
        OqsSdkProperties properties = new OqsSdkProperties();
        OqsSdkProperties.AuthConfig authConfig = new OqsSdkProperties.AuthConfig();
        authConfig.setAppId(appId);
        authConfig.setEnv(env);
        properties.setAuth(authConfig);

        EventConfiguration eventConfiguration = new EventConfiguration();

        DynamicConfig dynamicConfig = new DynamicConfig();
        
        ApplicationEventPublisher mockSpringPublisher = Mockito.mock(ApplicationEventPublisher.class);
        EventPublisher eventPublisher = eventConfiguration.localEventPublisher(mockSpringPublisher);
        EventEngine eventEngine = eventConfiguration.refreshableFactory(Arrays.asList(dynamicConfig), eventPublisher);

        BocpTransferStorageProperties storageProperties = new BocpTransferStorageProperties();
//

        IStorageStrategy storageStrategy;
        IMetadataStorage metadataStorage;
        //
        if (mode.equals("http")) {
            metadataStorage = httpMetadataStorage(bocpEnv);
            storageStrategy = new HttpStorageStrategy(metadataStorage);
        } else if (mode.equals("oss")) {
            metadataStorage = aliyunOssMetadataStorage(storageProperties);
            storageStrategy = new AliyunOssStorageStrategy(metadataStorage);
        } else {
            throw new RuntimeException("Mode is not Supported");
        }

        MetadataStorageRepository storageRepository = new MetadataStorageRepository(storageStrategy);
        MessageWorkerManager manager = new MessageWorkerManager();
        manager.init();
        EventStream<SDKMetadataEvent> eventEventStream = new RxEventStream<>();

        IBocpServerMessageListener bocpServerMessageListener = new BocpServerMessageListenerImpl(bocpClientSetting, properties, storageRepository,
                manager, eventEventStream);
        BocpClientSetting.Bocp bocp = new BocpClientSetting.Bocp();
        if (bocpEnv.equals("dev")) {
            bocp.setHost("ultraman-t.xforcecloud.com/bocp");
            bocp.setUseSsl(true);
            bocp.setPort("80");
        } else {
            bocp.setHost("ultraman.xforcecloud.com/bocp");
            bocp.setUseSsl(true);
            bocp.setPort("80");
        }

        if("1.6".equals(bocpCompat)) {
            bocp.setEnableSDKConfig(false);
        }

        bocpClientSetting.setBocp(bocp);
        client = new BocpClient(bocpClientSetting, properties, Collections.singletonList(bocpServerMessageListener));

        //MetadataEngine engine, GlobalInited globalInited, EventEngine eventEngine

        UltramanMetadataAutoConfiguration metadataAutoConfiguration = new UltramanMetadataAutoConfiguration();
        metadataAutoConfiguration.metadataRepository();
        MetadataEngine metadataEngine = metadataAutoConfiguration.ultramanMetadataEngine(executionConfig());
        EntityClassEngine entityClassEngine = metadataAutoConfiguration.entityClassEngine(metadataEngine);

        OqsDatasourceAutoConfiguration oqsDatasourceAutoConfiguration = new OqsDatasourceAutoConfiguration();
        DataSource dataSource = oqsDatasourceAutoConfiguration.dynamicDataSource(fetcher, contextService, dynamicConfig, environment);

        CdcConfig cdcConfig = new CdcConfig();
        EngineAdapterService noOp = null;
        if (useCdc) {

            clearFile("src/test/resource/cdc_luye");
            //CdcConfig cdc, CDCPropertyPackage cdcPropertyPackage, DataProcessor dataProcessor, @Autowired(required = false) CDCDestinationLock lock

            ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create(MysqlContainerExtension.class);
            CdcConfiguration cdcConfiguration = new CdcConfiguration();
            CDCPropertyPackage cdcPropertyPackage = cdcConfiguration.cdcPropertyPackage(environment);
            DataProcessor dataProcessor = cdcConfiguration.dataProcessor();
            DefaultDataProcessor defaultDataProcessor = (DefaultDataProcessor) dataProcessor;
            EventQueue eventQueue = cdcConfiguration.cdcEventQueue();

            noOp = Mockito.mock(EngineAdapterService.class);

            //add to one
            ToOneRelatedCallback oneRelatedCallback = new ToOneRelatedCallback();
            oneRelatedCallback.setDataSource(dataSource);
            oneRelatedCallback.setEngine(entityClassEngine);
            oneRelatedCallback.setContextService(contextService);
            
            defaultDataProcessor.setCdcBeforeCallbacks(Arrays.asList(oneRelatedCallback));
            defaultDataProcessor.setEventQueue(eventQueue);
            defaultDataProcessor.setPublisher(eventPublisher);
            defaultDataProcessor.setEngineAdapterService(noOp);
            //not wait-for
            if (useWaitFor) {
                ExecutorService executorService = ThreadFactoryHelper.buildThreadPool(10, 100, "test", false);
                DBStatusServiceImpl statusService = new DBStatusServiceImpl(executorService, dataSource);
                statusService.setLongIdGenerator(new SnowflakeLongIdGenerator(new StaticNodeIdGenerator(1)));
                statusService.setMainJdbcTemplate(new JdbcTemplate(dataSource));
            } else {
                defaultDataProcessor.setStatusService(null);
            }
            defaultDataProcessor.setEngine(entityClassEngine);

            CDCStarter cdcStarter = cdcConfiguration.cdcStarter(cdcConfig, cdcPropertyPackage, dataProcessor, null);
            cdcStarter.init();
        }

        GlobalInited globalInited = new GlobalInited(10, 10);
        SdkMetadataListener listener = new SdkMetadataListener(metadataEngine, globalInited, eventEngine, mockSpringPublisher);
//        listener.setEngine(metadataEngine);
//        listener.setEventEngine(eventEngine);
//        listener.setGlobalInited(globalInited);
        eventEventStream.subscribe(listener::onApplicationEvent);

        LocalEntityFacadeImpl entityFacade = new LocalEntityFacadeImpl();
        TransformerPipeline pipeline = pipeline(contextService);
        ConnectionAutoConfiguration configuration = new ConnectionAutoConfiguration();
        LocalOqsengineAutoConfiguration oqsengineAutoConfiguration = new LocalOqsengineAutoConfiguration();
        //metadataEngine metadataEngine, EntityClassEngine classEngine, DataQueryProvider queryProvider
        //            , ProfileFetcher fetcher, ContextService contextService, InvocationManager invocationManager
        //EntityQueryService queryService, ContextService contextService
        //DataSource ds
        //            , ObjectMapper mapper
        //            , @Qualifier("commonPool") ExecutorService executorService
        //            , EntityClassEngine engine
        //            , ExecutionConfig executionConfig
        //            , PlatformTransactionManager manager
        //            , CdcConfig cdcConfig
        //            , @Value("${xplat.oqsengine.sdk.schema.schedule.init:300}") long initTime
        //            , @Value("${xplat.oqsengine.sdk.schema.schedule.period:60}") long periodTime
        ExecutorService executorService = ThreadFactoryHelper.buildThreadPool(10, 10, "common", false);
        DataSourceTransactionManager manager1 = new DataSourceTransactionManager(dataSource);
        MasterStorage masterStorage = oqsengineAutoConfiguration.masterStorage(dataSource, new ObjectMapper(), executorService
                , entityClassEngine, executionConfig(), manager1, cdcConfig, 1000, 1000);
        EntityWriteService entityWriteService = new EntityWriteServiceImpl(masterStorage, entityClassEngine);
        EntityQueryService entityQueryService = new EntityQueryServiceImpl(masterStorage, entityClassEngine);
        LocalDataQueryProvider localDataQueryProvider = new LocalDataQueryProvider(entityQueryService, contextService);

        InvocationManager invocationManager = new QueryBasedInvocationManager(2000);
        FrameworkConfig config = configuration.frameworkConfig(metadataEngine, entityClassEngine, localDataQueryProvider, fetcher, contextService,
                invocationManager);
        DataSource calciteDS = configuration.ultramanConnection(metadataEngine, entityClassEngine, localDataQueryProvider, fetcher, contextService,
                invocationManager);
        entityFacade.setConfig(config);
        entityFacade.setAuthBuilder(null);
        entityFacade.setDataSource(calciteDS);
        entityFacade.setEngine(entityClassEngine);
        entityFacade.setFetcher(fetcher);
        entityFacade.setWriteService(entityWriteService);
        entityFacade.setTransformerPipeline(pipeline);
        entityFacade.setContextService(contextService);
        entityFacade.setIdGenerator(new SnowflakeLongIdGenerator(new StaticNodeIdGenerator(0)));

        BusinessFacadeAutoConfiguration businessFacadeAutoConfiguration = new BusinessFacadeAutoConfiguration();
        BusinessFacade businessFacade = businessFacadeAutoConfiguration.businessFacade(entityFacade
                , entityClassEngine
                , fetcher
                , executionConfig(), contextService);

        /**
         * changelog
         */
        //DataSource dataSource, EntityClassEngine engine, ObjectMapper mapper
        ChangelogFacade changelogFacade = new DefaultChangelogFacadeImpl(dataSource, entityClassEngine, new ObjectMapper());
        HistoryEventListener eventListener = new HistoryEventListener(mat);
        eventListener.setDataSource(dataSource);
        eventListener.setEngine(entityClassEngine);

        ChangeLogEventListener changeLogEventListener = new ChangeLogEventListener(mat, entityClassEngine);
        changeLogEventListener.setDataSource(dataSource);

        EntityCreatedEventExtractor createdEventExtractor = new EntityCreatedEventExtractor();
        EntityUpdatedEventExtractor updateEventExtractor = new EntityUpdatedEventExtractor();
        EntityDeletedEventExtractor deletedEventExtractor = new EntityDeletedEventExtractor();

        changeLogEventListener.setEventExtractors(Arrays.asList(createdEventExtractor, updateEventExtractor, deletedEventExtractor));
        
        //  EntityFacade entityFacade
        //            , EntityClassEngine engine
        //            , ProfileFetcher fetcher
        //            , ContextService contextService
        TenantAwareBusinessFacade tenantAwareBusinessFacade = new TenantAwareBusinessFacadeImpl(entityFacade, entityClassEngine, fetcher, contextService);

        Map<Class, Object> context = new HashMap<>();
        context.put(BusinessFacade.class, businessFacade);
        context.put(EntityClassEngine.class, entityClassEngine);
        context.put(PlatformTransactionManager.class, manager1);
        context.put(EngineAdapterService.class, noOp);
        context.put(ChangelogFacade.class, changelogFacade);
        context.put(ApplicationEventPublisher.class, mockSpringPublisher);
        context.put(HistoryEventListener.class, eventListener);
        context.put(ChangeLogEventListener.class, changeLogEventListener);
        context.put(MetadataEngine.class, metadataEngine);
        context.put(DynamicConfig.class, dynamicConfig);
        context.put(EventEngine.class, eventEngine);
        context.put(BocpClient.class, client);
        context.put(ContextService.class, contextService);
        context.put(TenantAwareBusinessFacade.class, tenantAwareBusinessFacade);
        return context;
    }

    private void clearFile(String s) throws IOException {
        File file = new File(s);
        if (file.exists()) {
            FileUtils.deleteDirectory(file);
        }
    }

    private IMetadataStorage httpMetadataStorage(String env) {
//        String bocpHost, Boolean useSsl, String apiPrefix, MetadataHeadInterceptor metadataHeadInterceptor
        String apiPrefix = "api/global/bocp";
        String baseUrl;
        String clientId = "tg_ultraman_auth";
        String authUrl;
        String secret;
        if (env.equalsIgnoreCase("dev")) {
            baseUrl = "ultraman-t.xforcecloud.com/bocp";
            authUrl = "https://paas-t.xforceplus.com";
            secret = "0QHOcifR1";
        } else {
            baseUrl = "ultraman.xforcecloud.com/bocp";
            authUrl = "https://paas-s.xforceplus.com";
            secret = "YVFY1q123Blp9c";
        }

//        String authUrl, String clientId, String secret
        GatewayTokenClient client = new GatewayTokenClient(authUrl, clientId, secret);
        TokenManager tokenManager = new TokenManager(client);
        MetadataHeadInterceptor metadataHeadInterceptor = new MetadataHeadInterceptor(tokenManager);
        return new HttpMetadataStorage(baseUrl, true, apiPrefix, metadataHeadInterceptor);
    }

    private AuthConfig authConfig(String appId, String env) {
        AuthConfig authConfig = new AuthConfig();
        authConfig.setAppId(appId);
        authConfig.setEnv(env);
        return authConfig;
    }

    protected ContextService contextService() {
        Map<String, Object> map = new ConcurrentHashMap<>();
        ContextService contextService = new ContextService() {
            @Override
            public <T> void set(ContextKey<T> contextKey, T t) {
                if (t == null) {
                    map.remove(contextKey.name());
                } else {
                    map.put(contextKey.name(), t);
                }
            }

            @Override
            public <T> T get(ContextKey<T> contextKey) {
                return (T) map.get(contextKey.name());
            }

            @Override
            public Map<String, Object> getAll() {
                return map;
            }

            @Override
            public void fromMap(Map<String, Object> map) {
                map.putAll(map);
            }

            @Override
            public void clear() {
                map.clear();
            }
        };

        return contextService;
    }

    protected ExecutorService executionService() {
        return Executors.newFixedThreadPool(10);
    }


    /**
     * pipeline
     *
     * @return
     */
    protected TransformerPipeline pipeline(ContextService service) {
        List<FieldOperationHandler> fieldOperationHandlers = new LinkedList<>();
        fieldOperationHandlers.add(new DefaultFieldValueOperationHandler());
        fieldOperationHandlers.add(new FixedDefaultSystemOperationHandler(service, false));
        MaxLengthValidator maxLengthValidator = new MaxLengthValidator();
        RequiredValidator requiredValidator = new RequiredValidator();
        List<FieldValidator<Object>> fieldValidators = new LinkedList<>();

        fieldValidators.add(maxLengthValidator);
        fieldValidators.add(requiredValidator);
        List<ExpTreeTransformer> treeTransformers = new LinkedList<>();
        //treeTransformers.add(calcite);
        treeTransformers.add(new QueryValueHandlerTransformer(Arrays
                .asList(new SimpleExpressionFieldOperationHandler(service)
                        , new AnotherSimpleExpressionFieldOperationHandler(service)
                ))
        );

//        treeTransformers.add(new EmptyConditionRemover());

        List<ExpTreeValidator> treeValidators = new LinkedList<>();
        treeValidators.add(new ExpRangeValidator(true));

        TransformerPipeline pipeline = new TransformerPipeline(
                fieldOperationHandlers
                , fieldValidators
                , treeTransformers
                , treeValidators);
        return pipeline;
    }

    /**
     * TODO
     *
     * @return
     */
    protected ExecutionConfig executionConfig() {
        ExecutionConfig config = new ExecutionConfig();
        config.setMetadataEnabled(false);
        config.setForce(true);
        config.setLegacy(true);

//        ObjectMapper mapper = new ObjectMapper();
//        String message = "{}";
//        try {
//            OperationResult compatible =
//                    entityServiceClient
//                            .compatible(CompatibleRequest.newBuilder().build())
//                            .toCompletableFuture().join();
//            message = compatible.getMessage();
//        } catch (Exception ex) {
//
//        }
//        Map<Compatibility, Boolean> compatibilityBooleanMap = null;
//        try {
//            compatibilityBooleanMap = mapper.readValue(message, new TypeReference<Map<Compatibility, Boolean>>() {
//            });
//        } catch (JsonProcessingException e) {
//            e.printStackTrace();
//        }
//        config.buildCompatibilityLine(compatibilityBooleanMap);
        return config;
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class type = parameterContext.getParameter().getType();
        return supportsParameters.contains(type);
    }

    /**
     * TODO
     *
     * @param parameterContext
     * @param extensionContext
     * @return
     * @throws ParameterResolutionException
     */
    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class type = parameterContext.getParameter().getType();

        ExtensionContext.Store store = extensionContext.getStore(ExtensionContext.Namespace.create(WhiteSdkExtension.class));
        return store.get(type);
    }
}
