package com.xforceplus.ultraman.oqsengine.plus.integration.test.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * abstract test
 * @param <T>
 */
public class AbstractTestParameter<T extends ExtensionTrait> implements TestParameter<T> {

    Map<String, String> values = new HashMap<>();

    @Override
    public String getValue(String key){
        return values.get(key);
    }

    @Override
    public void from(Map<String, String> value){
        this.values.putAll(value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AbstractTestParameter<?> that = (AbstractTestParameter<?>) o;
        return Objects.equals(values, that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(values);
    }

    @Override
    public String toString() {
        return "AbstractTestParameter{" +
                "values=" + values +
                '}';
    }
}
