package com.xforceplus.ultraman.oqsengine.plus.integration.test.framework;

import org.junit.jupiter.api.extension.*;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.*;
import java.util.stream.Collectors;

public abstract class AbstractUltramanExtension implements
          ExtensionTrait
        , BeforeAllCallback
        , BeforeEachCallback
        , AfterAllCallback
        , ParameterResolver
        , ExtensionContext.Store.CloseableResource {

    @Override
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        beforeEach(extensionContext);
    }

    @Override
    public void close() throws Throwable {
    }

    @Override
    public void afterAll(ExtensionContext context) throws Exception {

    }

    protected abstract void prepare(TestParameter parameter, ExtensionContext context);

    private boolean isSuitable(Class<? extends TestParameter> clazz, Class trait ) {

        Map<TypeVariable, Type> typeVariableMap = GenericTypeResolver.getTypeVariableMap(clazz);
        return typeVariableMap.values().stream().anyMatch(x -> x == trait);
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {

        Optional<AnnotatedElement> methodOp = context.getElement();
        if(methodOp.isPresent()) {
            Set<WithVars> allMergedAnnotations = AnnotatedElementUtils.getMergedRepeatableAnnotations(methodOp.get(), WithVars.class);
            List<WithVars> varList = allMergedAnnotations.stream().filter(x -> isSuitable(x.value(), this.getClass())).collect(Collectors.toList());

            varList.parallelStream().forEach(v -> {
                WithVars withVars = v;
                Class<? extends TestParameter> paramClass = withVars.value();

                TestParameter testParameter = null;
                try {
                    testParameter = paramClass.newInstance();
                } catch (InstantiationException | IllegalAccessException e) {
                    e.printStackTrace();
                }

                Map<String, String> params = new HashMap<>();
                Arrays.stream(withVars.params()).forEach(x -> {
                    params.put(x.k(), x.v());
                });

                testParameter.from(params);
                prepare(testParameter, context);
            });
        }
    }
}
