/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class ManticoreContainer
extends GenericContainer<ManticoreContainer> {
    private static final int MANTICORE_PORT = 9306;

    public ManticoreContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.addExposedPort(9306);
        this.withClasspathResourceMapping("manticore.conf", "/manticore.conf", BindMode.READ_ONLY);
        this.withClasspathResourceMapping("manticore.sql", "/init.sql", BindMode.READ_ONLY);
        this.withCommand(new String[]{"/usr/bin/searchd", "--nodetach", "--config", "/manticore.conf"});
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        try {
            Container.ExecResult execResult = this.execInContainer(new String[]{"mysql", "-h", "0", "-P", "9306", "-e", "source /init.sql"});
            System.out.println("Manticore" + execResult);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

