/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.containers.impl;

import com.xforceplus.ultraman.test.containers.AbstractContainerExtension;
import com.xforceplus.ultraman.test.enums.ContainerSupport;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class ElasticSearchContainer
extends AbstractContainerExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchContainer.class);
    private static final String ELASTICSEARCH_VERSION = "7.4.0";
    private GenericContainer container;
    public static final String ELASTICSEARCH_HOST = "ELASTICSEARCH_HOST";
    public static final String ELASTICSEARCH_PORT = "ELASTICSEARCH_PORT";

    @Override
    protected GenericContainer buildContainer() {
        this.container = new GenericContainer(DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch").withTag(ELASTICSEARCH_VERSION)).withNetworkAliases(new String[]{ElasticSearchContainer.buildAliase("elasticsearch")}).waitingFor(Wait.forListeningPort().withStartupTimeout(Duration.ofSeconds(200L))).withEnv("discovery.type", "single-node").withExposedPorts(new Integer[]{9200});
        return this.container;
    }

    @Override
    protected void init() {
        this.setSystemProperties(this.container.getHost(), this.container.getMappedPort(9200).toString());
    }

    private void setSystemProperties(String address, String port) {
        if (null == address || null == port) {
            throw new RuntimeException(String.format("container init failed of null value, address[%s] or port[%s]", address, port));
        }
        System.setProperty(ELASTICSEARCH_HOST, address);
        System.setProperty(ELASTICSEARCH_PORT, port);
        LOGGER.info("Start Redis server.({}:{})", (Object)address, (Object)port);
    }

    @Override
    protected void clean() {
    }

    @Override
    protected ContainerSupport containerSupport() {
        return ContainerSupport.ELASTICSEARCH;
    }

    @Override
    protected GenericContainer getGenericContainer() {
        return this.container;
    }
}

