/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlInitUtils.class);
    private static final String DELIMITER_COMMAND = "DELIMITER";
    private static final String PROCEDURE_COMMAND = "CALL";

    private static List<String> readSqls(String resource) throws IOException {
        URL url = SqlInitUtils.class.getResource(resource);
        if (url == null) {
            return Collections.emptyList();
        }
        File path = new File(url.getPath());
        String[] sqlFiles = path.list((dir, name) -> {
            String[] names = name.split("\\.");
            return names.length == 2 && names[1].equals("sql");
        });
        ArrayList<String> sqls = new ArrayList<String>();
        for (String file : sqlFiles) {
            String fullPath = String.format("%s%s%s", path.getAbsolutePath(), File.separator, file);
            LOGGER.info("Reader sql file: {}", (Object)fullPath);
            String lineEnd = ";";
            String annotation = "--";
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullPath), "utf8"));){
                String line;
                StringBuilder buff = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith(annotation)) continue;
                    if (SqlInitUtils.isDelimter(line)) {
                        lineEnd = SqlInitUtils.parseEndString(line);
                        continue;
                    }
                    buff.append(line);
                    if (!buff.toString().endsWith(lineEnd)) continue;
                    buff.delete(buff.length() - lineEnd.length(), buff.length());
                    sqls.add(buff.toString());
                    LOGGER.info(buff.toString());
                    buff = new StringBuilder();
                }
            }
        }
        return sqls;
    }

    public static void execute(String resource, DataSource dataSource) throws Exception {
        try (Connection conn = dataSource.getConnection();){
            SqlInitUtils.doExecute(resource, conn);
        }
    }

    public static void execute(String resource, String propertyName) throws Exception {
        try (Connection conn = DriverManager.getConnection(System.getProperty(propertyName));){
            SqlInitUtils.doExecute(resource, conn);
        }
    }

    private static void doExecute(String resource, Connection conn) throws Exception {
        List<String> sqls = SqlInitUtils.readSqls(resource);
        try (Statement st = conn.createStatement();){
            for (String sql : sqls) {
                if (SqlInitUtils.isCall(sql)) {
                    CallableStatement callSt = conn.prepareCall(sql);
                    Throwable throwable = null;
                    try {
                        callSt.executeQuery();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (callSt == null) continue;
                        if (throwable != null) {
                            try {
                                callSt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        callSt.close();
                        continue;
                    }
                }
                st.execute(sql);
            }
        }
    }

    private static boolean isCall(String sql) {
        return sql.startsWith(PROCEDURE_COMMAND) || sql.startsWith(PROCEDURE_COMMAND.toLowerCase());
    }

    private static boolean isDelimter(String command) {
        return command.toUpperCase(Locale.ROOT).startsWith(DELIMITER_COMMAND);
    }

    private static String parseEndString(String delimterCommand) {
        StringBuilder buff = new StringBuilder();
        buff.append(delimterCommand);
        buff.delete(0, DELIMITER_COMMAND.length());
        return buff.toString().trim();
    }

    public static void clean(DataSource ds) throws SQLException {
        try (Connection conn = ds.getConnection();){
            SqlInitUtils.doClean(conn);
        }
    }

    public static void clean(String propertyName) throws SQLException {
        try (Connection conn = DriverManager.getConnection(System.getProperty(propertyName));){
            SqlInitUtils.doClean(conn);
        }
    }

    private static void doClean(Connection connection) throws SQLException {
        try (Statement st = connection.createStatement();){
            ArrayList<String> tables = new ArrayList<String>();
            try (ResultSet rs = st.executeQuery("SHOW TABLES");){
                while (rs.next()) {
                    tables.add(rs.getString(1));
                }
            }
            for (String table : tables) {
                st.executeUpdate(String.format("TRUNCATE TABLE `%s`", table));
            }
        }
    }

    static {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

