package com.xforceplus.ultraman.test.containers.impl;

import com.xforceplus.ultraman.test.containers.AbstractContainerExtension;
import com.xforceplus.ultraman.test.enums.ContainerSupport;
import com.xforceplus.ultraman.test.enums.constant.Global;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

import java.time.Duration;

/**
 * @program: ultraman-oqsengine-plus
 * @ClassName elasticSearchContainer
 * @description:
 * @author: WanYi
 * @create: 2023-05-12 16:29
 * @Version 1.0
 **/

public class ElasticSearchContainer extends AbstractContainerExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchContainer.class);
    private static final String ELASTICSEARCH_VERSION = "7.4.0";

    private GenericContainer container;

    public static final String ELASTICSEARCH_HOST = "ELASTICSEARCH_HOST";
    public static final String ELASTICSEARCH_PORT = "ELASTICSEARCH_PORT";


    @Override
    protected GenericContainer buildContainer() {
        container = new GenericContainer
                (DockerImageName.parse("docker.elastic.co/elasticsearch/elasticsearch")
                        .withTag(ELASTICSEARCH_VERSION))
                .withNetworkAliases(buildAliase("elasticsearch"))
                .waitingFor(Wait.forListeningPort()
                        .withStartupTimeout(Duration.ofSeconds(Global.WAIT_START_TIME_OUT)))
                .withEnv("discovery.type", "single-node")
                .withExposedPorts(9200);
        return container;
    }

    @Override
    protected void init() {
        setSystemProperties(container.getHost(), container.getMappedPort(9200).toString());
    }

    private void setSystemProperties(String address, String port) {
        if (null == address || null == port) {
            throw new RuntimeException(
                    String.format("container init failed of null value, address[%s] or port[%s]", address, port));
        }

        System.setProperty(ELASTICSEARCH_HOST, address);
        System.setProperty(ELASTICSEARCH_PORT, port);

        LOGGER.info("Start Redis server.({}:{})", address, port);
    }

    @Override
    protected void clean() {
    }

    @Override
    protected ContainerSupport containerSupport() {
        return ContainerSupport.ELASTICSEARCH;
    }

    @Override
    protected GenericContainer getGenericContainer() {
        return this.container;
    }
}
