package com.xforceplus.ultraman.test.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class SimpleSdkContainer extends GenericContainer<CanalContainer> {

    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse("registry-developer.xforcecloud.com/ultraman-xplat-metadata/simple-sdk-app");

    private Integer port = 8085;

    private String appEnv;

    private String appId;

    private String oqsHost;

    private String oqsPort;

    private String env;

    public SimpleSdkContainer(String version) {
        super(DEFAULT_IMAGE_NAME.withTag(version));
    }

    public SimpleSdkContainer withPort(Integer port){
        this.port = port;
        return this;
    }

    public SimpleSdkContainer withAppId(String appId){
        this.appId = appId;
        return this;
    }

    public SimpleSdkContainer withAppEnv(String appEnv){
        this.appEnv = appEnv;
        return this;
    }

    public SimpleSdkContainer withOqsHost(String oqsHost){
        this.oqsHost = oqsHost;
        return this;
    }

    public SimpleSdkContainer withOqsPort(String oqsPort){
        this.oqsPort = oqsPort;
        return this;
    }

    public SimpleSdkContainer withEnv(String env){
        this.env = env;
        return this;
    }

    @Override
    public void configure(){
        withEnv("SERVER_PORT", port.toString());
        addExposedPort(port);

        //TODO check

        addEnv("XPLAT_OQSENGINE_SDK_AUTH_APP-ID", appId);
        addEnv("XPLAT_OQSENGINE_SDK_AUTH_ENV", appEnv);

        if(env.equals("dev")){
//            this.addEnv("META_GRPC_HOST", "120.55.249.44");
//            this.addEnv("META_GRPC_PORT", "23111");
            addEnv("BOCP_SERVER_HOST", "120.55.249.44");
            addEnv("BOCP_SERVER_PORT", "23111");
            addEnv("PFCP_ACCESSURI", "https://ultraman-t.xforcecloud.com/pfcp");
        } else {
            addEnv("BOCP_SERVER_HOST", "ultraman.xforcecloud.com");
            addEnv("BOCP_SERVER_PORT", "23120");
            addEnv("PFCP_ACCESSURI", "https://ultraman.xforcecloud.com/pfcp");
        }

        addEnv("OQSENGINE_SERVER_HOST", oqsHost);
        addEnv("OQSENGINE_SERVER_PORT", oqsPort);
    }
}
