//package com.xforceplus.ultraman.oqsengine.plus.integration.test.extend;
//
//import com.xforceplus.ultraman.oqsengine.plus.integration.test.framework.AbstractUltramanExtension;
//import com.xforceplus.ultraman.oqsengine.plus.integration.test.framework.OqsContainerResource;
//import com.xforceplus.ultraman.oqsengine.plus.integration.test.framework.OqsExtension;
//import com.xforceplus.ultraman.oqsengine.plus.integration.test.framework.TestParameter;
//import containers.OqsContainer;
//import containers.SimpleSdkContainer;
//import org.apache.commons.lang3.StringUtils;
//import org.junit.jupiter.api.extension.ExtensionContext;
//import org.junit.jupiter.api.extension.ParameterContext;
//import org.junit.jupiter.api.extension.ParameterResolutionException;
//import org.springframework.expression.EvaluationContext;
//import org.springframework.expression.Expression;
//import org.springframework.expression.ExpressionParser;
//import org.springframework.expression.spel.standard.SpelExpressionParser;
//import org.springframework.expression.spel.support.StandardEvaluationContext;
//import org.testcontainers.containers.Network;
//import org.testcontainers.containers.wait.strategy.Wait;
//
//import java.util.*;
//import java.util.stream.Collectors;
//
//public class BlackSdkExtension extends AbstractUltramanExtension {
//
//    private Set<Class> supportsParameters = new HashSet<>();
//
//    public BlackSdkExtension() {
//        supportsParameters.add(SimpleSdkContainer.class);
//    }
//
//    @Override
//    protected void prepare(TestParameter parameter, ExtensionContext context) {
//
//        String oqs = parameter.getValue(BlackSdkParameters.OQS_HOST);
//        String port = parameter.getValue(BlackSdkParameters.OQS_PORT);
//        String appId = parameter.getValue(BlackSdkParameters.APP_ID);
//        String env = parameter.getValue(BlackSdkParameters.APP_ENV);
//        String bocpEnv = parameter.getValue(BlackSdkParameters.BOCP_ENV);
//        String sdkVersion = parameter.getValue(BlackSdkParameters.SIMPLE_VERSION);
//        String sdkPort = parameter.getValue(BlackSdkParameters.SDK_PORT);
//
//        String realHost = oqs;
//        String realPort = port;
//
//        Map<Class, Object> sdkContext;
//
//        Network network = null;
//        if (StringUtils.isEmpty(oqs) || StringUtils.isEmpty(port)) {
//            realHost = "localhost";
//            realPort = "8081";
//        } else {
//            ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create(OqsExtension.class));
//            if (store != null) {
//                OqsContainerResource resource = (OqsContainerResource) store.get(OqsContainerResource.class);
//                if (resource != null) {
//                    Optional<OqsContainer> any = resource.getOqs().stream().filter(x -> x.getContainerName().equals(oqs)).findAny();
//                    if (any.isPresent()) {
//                        network = any.get().getNetwork();
//                    }
//                }
//            }
//        }
//
//        SimpleSdkContainer simpleSdkContainer = startSdkContainer(sdkVersion, appId, env, bocpEnv, realHost, realPort, sdkPort, network);
//
//        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create(BlackSdkExtension.class));
//        store.put(SimpleSdkContainer.class, simpleSdkContainer);
//    }
//
//    private SimpleSdkContainer startSdkContainer(String sdkVersion, String appId
//            , String env, String bocpEnv, String oqsHost, String oqsPort, String sdkPort, Network network) {
//        SimpleSdkContainer container = new SimpleSdkContainer(sdkVersion)
//                .withAppId(appId)
//                .withAppEnv(env)
//                .withEnv(bocpEnv)
//                .withOqsHost(oqsHost)
//                .withOqsPort(oqsPort)
//                .withPort(Integer.parseInt(sdkPort));
//
//
//        container.withLogConsumer(x -> {
//            System.out.println("SIMPLE-SDK" + "::::" + x.getUtf8String());
//        });
//
//        if (network != null) {
//            container.withNetwork(network);
//        }
//
//        container.waitingFor(Wait.forListeningPort());
//
//        container.start();
//
//        return container;
//    }
//
//    private String getValue(String spel, ExtensionContext.Store store) {
//        ExpressionParser expressionParser = new SpelExpressionParser();
//        Expression expression = expressionParser.parseExpression(spel);
//
//        //prepare for the oqsengine
//
//        OqsContainerResource o = (OqsContainerResource) store.get(OqsContainerResource.class);
//
//
//        Map<String, OqsContainer> oqsContainersMapping = Optional.ofNullable(o).map(x -> x.getOqs())
//                .orElse(Collections.emptyList()).
//                        stream()
//                .peek(x -> {
//                    while (!x.isRunning()) {
//                        try {
//                            System.out.println("Waiting Health for " + x.getContainerName());
//                            Thread.sleep(1000);
//                        } catch (InterruptedException e) {
//                            e.printStackTrace();
//                        }
//                    }
//                })
//                .collect(Collectors.toMap(x -> x.getContainerName(), x -> x, (a, b) -> a));
//
//        EvaluationContext evalContext = new StandardEvaluationContext(oqsContainersMapping);
//
//        return expression.getValue(evalContext).toString();
//    }
//
//    @Override
//    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
//        Class type = parameterContext.getParameter().getType();
//        return supportsParameters.contains(type);
//    }
//
//    @Override
//    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
//        Class type = parameterContext.getParameter().getType();
//        ExtensionContext.Store store = extensionContext.getStore(ExtensionContext.Namespace.create(BlackSdkExtension.class));
//        return store.get(type);
//    }
//}
