package com.xforceplus.ultraman.test.extend;

import org.testcontainers.containers.GenericContainer;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * simple context
 */
public class ContainerContext {

    public final static Map<TestParameter, GenericContainer> containerCache = new ConcurrentHashMap<>();

    private static Map<Class, List<GenericContainer>> context = new ConcurrentHashMap<>();

    public static void putContainer(TestParameter parameter, GenericContainer container) {
        containerCache.put(parameter, container);

        context.compute(container.getClass(), (k, v) -> {
            if (v == null) {
                v = new LinkedList<>();
            }

            v.add(container);
            return v;
        });
    }

    public static GenericContainer getContainer(TestParameter parameter) {
        return containerCache.get(parameter);
    }

    public static List<GenericContainer> getCurrentContainer(Class<? extends GenericContainer> containerClass) {
        return context.get(containerClass);
    }

    public static GenericContainer getCurrentOneContainer(Class<? extends GenericContainer> containerClass) {
        List<GenericContainer> genericContainers = context.get(containerClass);

        if(genericContainers.isEmpty()){
            return null;
        } else {
            return genericContainers.get(0);
        }
    }
}
