/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.containers;

import com.xforceplus.ultraman.test.enums.ContainerSupport;
import com.xforceplus.ultraman.test.enums.constant.Global;
import com.xforceplus.ultraman.test.extend.AbstractUltramanExtension;
import com.xforceplus.ultraman.test.extend.TestParameter;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public abstract class AbstractUltramanContainerExtension
extends AbstractUltramanExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUltramanContainerExtension.class);
    private static final int MAX_TRY_NUMBER = 6;
    private static final int REPLAY_WAIT_TIME_MS = 60000;
    private static final String GLOBAL_NAME = UUID.randomUUID().toString();

    @Override
    protected void prepare(TestParameter parameter, ExtensionContext context) {
        LOGGER.info("Start the container {}...", (Object)this.containerSupport().name());
        for (int i = 0; i < 6; ++i) {
            GenericContainer container = this.buildContainer(parameter);
            if (Global.startContainer(container)) {
                container.followOutput(outputFrame -> LOGGER.info(outputFrame.getUtf8String()));
                this.init(parameter);
                LOGGER.info("Start the container {}... OK!", (Object)this.containerSupport().name());
                return;
            }
            LOGGER.info("Failed to start container {}, wait {} seconds and try again.[{}/{}]", new Object[]{this.containerSupport().name(), TimeUnit.MILLISECONDS.toSeconds(60000L), i + 1, 6});
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(60000L));
        }
        throw new IllegalStateException(String.format("Failed to start container %s.", this.containerSupport().name()));
    }

    @Override
    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.afterAll(extensionContext);
        LOGGER.info("Close the container {}...", (Object)this.containerSupport().name());
        this.clean();
        Global.closeContainer(this.getGenericContainer());
        LOGGER.info("Close the container {}...OK!", (Object)this.containerSupport().name());
    }

    public static String globalName() {
        return GLOBAL_NAME;
    }

    public static String buildAliase(String name) {
        return String.format("%s-%s", GLOBAL_NAME, name);
    }

    protected abstract GenericContainer buildContainer(TestParameter var1);

    protected abstract void init(TestParameter var1);

    protected abstract void clean();

    protected abstract ContainerSupport containerSupport();

    protected abstract GenericContainer getGenericContainer();
}

