/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.containers;

import java.util.Objects;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class CanalContainer
extends GenericContainer<CanalContainer> {
    private static int CANAL_PORT = 11111;
    private String slaveId = "12";
    private boolean autoScan = false;
    private String destination = null;
    private String masterAddress = "mysql:3306";
    private String username = "root";
    private String password = "root";
    private String regexFilter = ".*\\.oqsbigentity.*";

    public CanalContainer withSlaveId(String id) {
        this.slaveId = id;
        return this;
    }

    public CanalContainer withAutoScan(boolean autoScan) {
        this.autoScan = autoScan;
        return this;
    }

    public CanalContainer withDestination(String destination) {
        this.destination = destination;
        return this;
    }

    public CanalContainer withMasterAddress(String masterAddress) {
        this.masterAddress = masterAddress;
        return this;
    }

    public CanalContainer withDbUserName(String username) {
        this.username = username;
        return this;
    }

    public CanalContainer withDbPassword(String password) {
        this.password = password;
        return this;
    }

    public CanalContainer withRegexFilter(String regexFilter) {
        this.regexFilter = regexFilter;
        return this;
    }

    public CanalContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.addExposedPort(CANAL_PORT);
    }

    public void configure() {
        Objects.requireNonNull(this.destination, "destination cannot be null");
        this.withEnv("canal.instance.mysql.slaveId", this.slaveId);
        this.withEnv("canal.auto.scan", Boolean.toString(this.autoScan));
        this.withEnv("canal.destinations", this.destination);
        this.withEnv("canal.instance.master.address", this.masterAddress);
        this.withEnv("canal.instance.dbUsername", this.username);
        this.withEnv("canal.instance.dbPassword", this.password);
        this.withEnv("canal.instance.filter.regex", this.regexFilter);
    }
}

