/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.containers;

import com.xforceplus.ultraman.test.containers.CanalContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class SimpleSdkContainer
extends GenericContainer<CanalContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"registry-developer.xforcecloud.com/ultraman-xplat-metadata/simple-sdk-app");
    private Integer port = 8085;
    private String appEnv;
    private String appId;
    private String oqsHost;
    private String oqsPort;
    private String env;

    public SimpleSdkContainer(String version) {
        super(DEFAULT_IMAGE_NAME.withTag(version));
    }

    public SimpleSdkContainer withPort(Integer port) {
        this.port = port;
        return this;
    }

    public SimpleSdkContainer withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public SimpleSdkContainer withAppEnv(String appEnv) {
        this.appEnv = appEnv;
        return this;
    }

    public SimpleSdkContainer withOqsHost(String oqsHost) {
        this.oqsHost = oqsHost;
        return this;
    }

    public SimpleSdkContainer withOqsPort(String oqsPort) {
        this.oqsPort = oqsPort;
        return this;
    }

    public SimpleSdkContainer withEnv(String env) {
        this.env = env;
        return this;
    }

    public void configure() {
        this.withEnv("SERVER_PORT", this.port.toString());
        this.addExposedPort(this.port);
        this.addEnv("XPLAT_OQSENGINE_SDK_AUTH_APP-ID", this.appId);
        this.addEnv("XPLAT_OQSENGINE_SDK_AUTH_ENV", this.appEnv);
        if (this.env.equals("dev")) {
            this.addEnv("BOCP_SERVER_HOST", "120.55.249.44");
            this.addEnv("BOCP_SERVER_PORT", "23111");
            this.addEnv("PFCP_ACCESSURI", "https://ultraman-t.xforcecloud.com/pfcp");
        } else {
            this.addEnv("BOCP_SERVER_HOST", "ultraman.xforcecloud.com");
            this.addEnv("BOCP_SERVER_PORT", "23120");
            this.addEnv("PFCP_ACCESSURI", "https://ultraman.xforcecloud.com/pfcp");
        }
        this.addEnv("OQSENGINE_SERVER_HOST", this.oqsHost);
        this.addEnv("OQSENGINE_SERVER_PORT", this.oqsPort);
    }
}

