/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.containers.impl;

import com.xforceplus.ultraman.test.containers.AbstractUltramanContainerExtension;
import com.xforceplus.ultraman.test.enums.ContainerSupport;
import com.xforceplus.ultraman.test.extend.TestParameter;
import com.xforceplus.ultraman.test.utils.SqlInitUtils;
import java.time.Duration;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class ElasticSearchContainerExtension
extends AbstractUltramanContainerExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchContainerExtension.class);
    private static final String ELASTICSEARCH_VERSION = "7.4.0";
    private GenericContainer container;
    public static final String ELASTICSEARCH_HOST = "ELASTICSEARCH_HOST";
    public static final String ELASTICSEARCH_PORT = "ELASTICSEARCH_PORT";

    @Override
    protected GenericContainer buildContainer(TestParameter parameter) {
        this.container = new GenericContainer(DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch").withTag(ELASTICSEARCH_VERSION)).withNetworkAliases(new String[]{ElasticSearchContainerExtension.buildAliase("elasticsearch")}).waitingFor(Wait.forListeningPort().withStartupTimeout(Duration.ofSeconds(200L))).withEnv("discovery.type", "single-node").withExposedPorts(new Integer[]{9200});
        return this.container;
    }

    @Override
    protected void init(TestParameter parameter) {
        this.setSystemProperties(this.container.getHost(), this.container.getMappedPort(9200).toString());
    }

    private void setSystemProperties(String address, String port) {
        if (null == address || null == port) {
            throw new RuntimeException(String.format("container init failed of null value, address[%s] or port[%s]", address, port));
        }
        System.setProperty(ELASTICSEARCH_HOST, address);
        System.setProperty(ELASTICSEARCH_PORT, port);
        LOGGER.info("Start ElasticSearch server.({}:{})", (Object)address, (Object)port);
    }

    @Override
    protected void clean() {
        if (this.container != null) {
            try {
                SqlInitUtils.clean(ELASTICSEARCH_HOST);
                SqlInitUtils.clean(ELASTICSEARCH_PORT);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected ContainerSupport containerSupport() {
        return ContainerSupport.ELASTICSEARCH;
    }

    @Override
    protected GenericContainer getGenericContainer() {
        return this.container;
    }

    @Override
    protected void prepare(TestParameter parameter, ExtensionContext context) {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return null;
    }
}

