/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.extend;

import com.xforceplus.ultraman.test.extend.ExtensionTrait;
import com.xforceplus.ultraman.test.extend.TestParameter;
import com.xforceplus.ultraman.test.extend.WithVars;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;

public abstract class AbstractUltramanExtension
implements ExtensionTrait,
BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
ParameterResolver,
ExtensionContext.Store.CloseableResource {
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.beforeEach(extensionContext);
    }

    public void close() throws Throwable {
    }

    public void afterAll(ExtensionContext context) throws Exception {
    }

    protected abstract void prepare(TestParameter var1, ExtensionContext var2);

    private boolean isSuitable(Class<? extends TestParameter> clazz, Class trait) {
        Map typeVariableMap = GenericTypeResolver.getTypeVariableMap(clazz);
        return typeVariableMap.values().stream().anyMatch(x -> x == trait);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Optional methodOp = context.getElement();
        if (methodOp.isPresent()) {
            Set allMergedAnnotations = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)((AnnotatedElement)methodOp.get()), WithVars.class);
            List varList = allMergedAnnotations.stream().filter(x -> this.isSuitable(x.value(), this.getClass())).collect(Collectors.toList());
            varList.parallelStream().forEach(v -> {
                WithVars withVars = v;
                Class<? extends TestParameter> paramClass = withVars.value();
                TestParameter testParameter = null;
                try {
                    testParameter = paramClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                HashMap<String, String> params = new HashMap<String, String>();
                Arrays.stream(withVars.params()).forEach(x -> params.put(x.k(), x.v()));
                testParameter.from(params);
                this.prepare(testParameter, context);
            });
        }
    }
}

