/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.extend;

import com.xforceplus.ultraman.test.extend.TestParameter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testcontainers.containers.GenericContainer;

public class ContainerContext {
    public static final Map<TestParameter, GenericContainer> containerCache = new ConcurrentHashMap<TestParameter, GenericContainer>();
    private static Map<Class, List<GenericContainer>> context = new ConcurrentHashMap<Class, List<GenericContainer>>();

    public static void putContainer(TestParameter parameter, GenericContainer container) {
        containerCache.put(parameter, container);
        context.compute(container.getClass(), (k, v) -> {
            if (v == null) {
                v = new LinkedList<GenericContainer>();
            }
            v.add(container);
            return v;
        });
    }

    public static GenericContainer getContainer(TestParameter parameter) {
        return containerCache.get(parameter);
    }

    public static List<GenericContainer> getCurrentContainer(Class<? extends GenericContainer> containerClass) {
        return context.get(containerClass);
    }

    public static GenericContainer getCurrentOneContainer(Class<? extends GenericContainer> containerClass) {
        List<GenericContainer> genericContainers = context.get(containerClass);
        if (genericContainers.isEmpty()) {
            return null;
        }
        return genericContainers.get(0);
    }
}

