package com.xforceplus.ultraman.test.containers.impl;

import com.xforceplus.ultraman.test.containers.AbstractUltramanContainerExtension;
import com.xforceplus.ultraman.test.enums.ContainerSupport;
import com.xforceplus.ultraman.test.enums.constant.Global;
import com.xforceplus.ultraman.test.extend.TestParameter;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

import java.time.Duration;

/**
 * Created by justin.xu on 06/2023.
 *
 * @since 1.8
 */
public class CanalContainerExtension extends AbstractUltramanContainerExtension {


    private static final Logger
        LOGGER = LoggerFactory.getLogger(CanalContainerExtension.class);

    private GenericContainer container;

    @Override
    protected GenericContainer buildContainer(TestParameter parameter) {
        System.setProperty("CANAL_DESTINATION_FIRST", "oqsengine-first");

        container = new GenericContainer("canal/canal-server:v1.1.4")
            .withNetworkAliases(buildAliase("canal_first"))
            .withExposedPorts(11111)
            .withEnv("canal.instance.mysql.slaveId", "11")
            .withEnv("canal.auto.scan", "false")
            .withEnv("canal.destinations", System.getProperty("CANAL_DESTINATION_FIRST"))
            .withEnv("canal.instance.master.address", String.join(":", buildAliase("mysql"), "3306"))
            .withEnv("canal.instance.dbUsername", "root")
            .withEnv("canal.instance.dbPassword", "root")
            .withEnv("canal.instance.filter.regex", ".*\\.oqsbigentity_first.*")
            .waitingFor(Wait.forListeningPort().withStartupTimeout(Duration.ofSeconds(Global.WAIT_START_TIME_OUT)));

        return container;
    }


    @Override
    protected void init(TestParameter parameter) {
        setSystemProperties(container.getHost(), container.getMappedPort(11111).toString());
    }

    @Override
    protected void clean() {

    }

    @Override
    protected ContainerSupport containerSupport() {
        return ContainerSupport.CANAL;
    }

    @Override
    protected GenericContainer getGenericContainer() {
        return this.container;
    }

    private void setSystemProperties(String address, String port) {

        if (null == address || null == port) {
            throw new RuntimeException(
                String.format("container canal init failed of null value, address[%s] or port[%s]", address, port));
        }

        System.setProperty("CANAL_HOST_FIRST", address);
        System.setProperty("CANAL_PORT_FIRST", port);

        LOGGER.info("Start canal server.({}:{})", address, port);
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return false;
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return null;
    }
}
