/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.containers.impl;

import com.xforceplus.ultraman.test.containers.AbstractUltramanContainerExtension;
import com.xforceplus.ultraman.test.enums.ContainerSupport;
import com.xforceplus.ultraman.test.extend.TestParameter;
import java.time.Duration;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class CanalContainerExtension
extends AbstractUltramanContainerExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanalContainerExtension.class);
    private GenericContainer container;

    @Override
    protected GenericContainer buildContainer(TestParameter parameter) {
        System.setProperty("CANAL_DESTINATION_FIRST", "oqsengine-first");
        this.container = new GenericContainer("canal/canal-server:v1.1.4").withNetworkAliases(new String[]{CanalContainerExtension.buildAliase("canal_first")}).withExposedPorts(new Integer[]{11111}).withEnv("canal.instance.mysql.slaveId", "11").withEnv("canal.auto.scan", "false").withEnv("canal.destinations", System.getProperty("CANAL_DESTINATION_FIRST")).withEnv("canal.instance.master.address", String.join((CharSequence)":", CanalContainerExtension.buildAliase("mysql"), "3306")).withEnv("canal.instance.dbUsername", "root").withEnv("canal.instance.dbPassword", "root").withEnv("canal.instance.filter.regex", ".*\\.oqsbigentity_first.*").waitingFor(Wait.forListeningPort().withStartupTimeout(Duration.ofSeconds(200L)));
        return this.container;
    }

    @Override
    protected void init(TestParameter parameter) {
        this.setSystemProperties(this.container.getHost(), this.container.getMappedPort(11111).toString());
    }

    @Override
    protected void clean() {
    }

    @Override
    protected ContainerSupport containerSupport() {
        return ContainerSupport.CANAL;
    }

    @Override
    protected GenericContainer getGenericContainer() {
        return this.container;
    }

    private void setSystemProperties(String address, String port) {
        if (null == address || null == port) {
            throw new RuntimeException(String.format("container canal init failed of null value, address[%s] or port[%s]", address, port));
        }
        System.setProperty("CANAL_HOST_FIRST", address);
        System.setProperty("CANAL_PORT_FIRST", port);
        LOGGER.info("Start canal server.({}:{})", (Object)address, (Object)port);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return null;
    }
}

