/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.bocp.auth.interceptor;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.AppMapper;
import com.xforceplus.ultraman.metadata.bocp.auth.annotations.AllowedAppCustomType;
import com.xforceplus.ultraman.metadata.bocp.auth.context.UltramanUserHolder;
import com.xforceplus.ultraman.metadata.bocp.auth.service.IUltramanContextService;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class UltramanContextInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UltramanContextInterceptor.class);
    private final IUltramanContextService ultramanContextService;
    private final AppMapper appMapper;

    public UltramanContextInterceptor(IUltramanContextService ultramanContextService, AppMapper appMapper) {
        log.info("ultraman-auth.UltramanContextInterceptor initializing...");
        this.ultramanContextService = ultramanContextService;
        this.appMapper = appMapper;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler instanceof HandlerMethod) {
            AllowedAppCustomType annotationToUse;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            AllowedAppCustomType methodAnnotation = (AllowedAppCustomType)handlerMethod.getMethodAnnotation(AllowedAppCustomType.class);
            AllowedAppCustomType classAnnotation = handlerMethod.getBeanType().getAnnotation(AllowedAppCustomType.class);
            AllowedAppCustomType allowedAppCustomType = annotationToUse = methodAnnotation != null ? methodAnnotation : classAnnotation;
            if (annotationToUse != null) {
                Long appId;
                App app;
                String[] parts;
                AppCustomType[] allowedTypes = annotationToUse.appCustomTypes();
                String requestURI = request.getRequestURI();
                if (requestURI.startsWith("/apps/") && (parts = requestURI.split("/")).length >= 3 && StringUtils.isNumeric((CharSequence)parts[2]) && null != (app = (App)this.appMapper.selectById((Serializable)(appId = Long.valueOf(Long.parseLong(parts[2])))))) {
                    for (AppCustomType allowedType : allowedTypes) {
                        if (!allowedType.code().equals(app.getCustomType())) continue;
                        return true;
                    }
                    try {
                        String warnMsg = String.format("\u5e94\u7528\u4e3a%s\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u8bbf\u95ee\u5f53\u524d\u8bf7\u6c42", app.getCustomType());
                        response.sendError(500, warnMsg);
                        log.warn(warnMsg);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UltramanUserHolder.clearContext();
        log.info("tenant-security.UserInfoHolder.clear...");
    }

    private Long getAppId(HttpServletRequest request, HandlerMethod handlerMethod) {
        Parameter[] parameters;
        Method targetMethod = handlerMethod.getMethod();
        for (Parameter parameter : parameters = targetMethod.getParameters()) {
            Map parameterMap;
            String[] appIdValues;
            if (!parameter.getName().equals("appId") || (appIdValues = (String[])(parameterMap = request.getParameterMap()).get("appId")) == null || appIdValues.length <= 0) continue;
            return Long.parseLong(appIdValues[0]);
        }
        return null;
    }
}

