/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.bocp.auth.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.vo.RoleVo;
import com.xforceplus.ultraman.bocp.metadata.vo.TenantVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.UserAppRoleAuth;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.UserTenantAuth;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.UserAppRoleAuthMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.UserInfoMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.UserTenantAuthMapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UserRepository {
    private UserInfoMapper userInfoMapper;
    private UserAppRoleAuthMapper userAppRoleAuthMapper;
    private UserTenantAuthMapper userTenantAuthMapper;

    public UserRepository(UserInfoMapper userInfoMapper, UserAppRoleAuthMapper userAppRoleAuthMapper, UserTenantAuthMapper userTenantAuthMapper) {
        this.userInfoMapper = userInfoMapper;
        this.userAppRoleAuthMapper = userAppRoleAuthMapper;
        this.userTenantAuthMapper = userTenantAuthMapper;
    }

    public List<UserAppRoleAuth> getRoles(Long userId) {
        return this.userAppRoleAuthMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserAppRoleAuth::getUserId, (Object)userId)).eq(UserAppRoleAuth::getDeleteFlag, (Object)"1"));
    }

    public List<UserTenantAuth> getTenants(Long userId) {
        return this.userTenantAuthMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserTenantAuth::getUserId, (Object)userId)).eq(UserTenantAuth::getDeleteFlag, (Object)"1"));
    }

    public Map<Long, List<RoleVo>> getAppRolesMap(Long userId) {
        return this.getRoles(userId).stream().collect(Collectors.groupingBy(UserAppRoleAuth::getAppId)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(v -> {
            RoleVo roleVo = new RoleVo();
            roleVo.setRoleId(v.getRoleId());
            roleVo.setRoleName(v.getRoleName());
            roleVo.setRoleCode(v.getRoleCode());
            roleVo.setRoleType(v.getRoleType());
            return roleVo;
        }).collect(Collectors.toList())));
    }

    public List<TenantVo> getTenantVos(Long userId) {
        return this.getTenants(userId).stream().map(e -> {
            TenantVo tenantVo = new TenantVo();
            tenantVo.setTenantId(e.getTenantId());
            tenantVo.setTenantName(e.getTenantName());
            tenantVo.setTenantCode(e.getTenantCode());
            return tenantVo;
        }).collect(Collectors.toList());
    }
}

