/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.bocp.auth.service.impl;

import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.bocp.metadata.infra.util.AppRoleUtil;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.AppStructMapper;
import com.xforceplus.ultraman.bocp.metadata.vo.AppVo;
import com.xforceplus.ultraman.bocp.metadata.vo.TenantVo;
import com.xforceplus.ultraman.metadata.bocp.auth.domain.UltramanUser;
import com.xforceplus.ultraman.metadata.bocp.auth.repository.UserRepository;
import com.xforceplus.ultraman.metadata.bocp.auth.service.IUltramanContextService;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UltramanContextServiceImpl
implements IUltramanContextService {
    private static final Logger log = LoggerFactory.getLogger(UltramanContextServiceImpl.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private AppRepository appRepository;

    @Override
    public UltramanUser getCurrentUser() {
        List<Object> appVos;
        if (null == UserInfoHolder.get()) {
            log.warn("\u6ca1\u6709\u7528\u6237\u4e2d\u5fc3\u4e0a\u4e0b\u6587");
            return null;
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        UltramanUser ultramanUser = new UltramanUser();
        ultramanUser.setAppRoles(this.userRepository.getAppRolesMap(authorizedUser.getId()));
        ultramanUser.setTenants(this.userRepository.getTenantVos(authorizedUser.getId()));
        ultramanUser.setAdmin(this.isUltramanAdminFromUserCenter(authorizedUser));
        if (ultramanUser.isAdmin()) {
            appVos = this.appRepository.getAllApps().stream().map(arg_0 -> ((AppStructMapper)AppStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList());
            ultramanUser.setStandardTenantApps(this.filterAppCustomType(appVos, AppCustomType.TENANT));
            ultramanUser.setCustomApps(this.filterAppCustomType(appVos, AppCustomType.CUSTOM));
        } else {
            appVos = this.appRepository.getAppByIds(new ArrayList<Long>(ultramanUser.getAppRoles().keySet())).stream().map(arg_0 -> ((AppStructMapper)AppStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList());
            ultramanUser.setStandardTenantApps(this.filterAppByCustomTypeAndTenant(appVos, AppCustomType.TENANT, ultramanUser.getTenants()));
            ultramanUser.setCustomApps(this.filterAppByCustomTypeAndTenant(appVos, AppCustomType.CUSTOM, ultramanUser.getTenants()));
        }
        ultramanUser.setStandardApps(this.filterAppCustomType(appVos, AppCustomType.STANDARD));
        return ultramanUser;
    }

    private boolean isUltramanAdmin(UltramanUser ultramanUser) {
        return ultramanUser.getAppRoles().containsKey(AppRoleUtil.ULTRAMAN_APP_ID) && ultramanUser.getAppRoles().get(AppRoleUtil.ULTRAMAN_APP_ID).stream().filter(r -> "ultramanAdmin".equals(r.getRoleCode())).count() > 0L;
    }

    private boolean isUltramanAdminFromUserCenter(IAuthorizedUser authorizedUser) {
        Set roles = authorizedUser.getRoles();
        return roles.stream().filter(r -> "ultramanAdmin".equals(r.getCode())).count() > 0L;
    }

    private List<AppVo> filterAppCustomType(List<AppVo> appVos, AppCustomType appCustomType) {
        return appVos.stream().filter(a -> appCustomType.code().equals(a.getCustomType())).collect(Collectors.toList());
    }

    private List<AppVo> filterAppByCustomTypeAndTenant(List<AppVo> appVos, AppCustomType appCustomType, List<TenantVo> tenantVos) {
        return appVos.stream().filter(a -> appCustomType.code().equals(a.getCustomType())).collect(Collectors.toList());
    }
}

