/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.datarule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoDataRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleStatus;
import com.xforceplus.ultraman.bocp.metadata.datarule.service.IBoDataRuleExService;
import com.xforceplus.ultraman.bocp.metadata.datarule.validator.DataRuleValidator;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.validator.ValidateResponse;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoDataRuleMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoDataRuleExServiceImpl
implements IBoDataRuleExService {
    @Autowired
    private DataRuleValidator dataRuleValidator;
    @Autowired
    private IBoDataRuleService boDataRuleService;
    @Autowired
    private BoDataRuleMapper boDataRuleMapper;
    @Autowired
    private BoRepository boRepository;

    @Override
    public ServiceResponse saveDataRule(BoDataRule dataRule) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCreateDefault(dataRule);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        dataRule.setId(null);
        dataRule.setUniqueId(null);
        dataRule.setPublishFlag(PublishFlag.UNPUBLISHED.code());
        dataRule.setVersion("0.0.0");
        dataRule.setStatus(DataRuleStatus.fromCode((String)dataRule.getStatus()).code());
        if (StringUtils.isNotEmpty((CharSequence)dataRule.getTenantCode())) {
            Bo tenantBo = this.boRepository.getBoWithValidate(dataRule.getBoId());
            dataRule.setRefBoId(tenantBo.getRefBoId());
        }
        return this.boDataRuleService.save((Object)dataRule) ? ServiceResponse.success() : ServiceResponse.fail((String)"\u65b0\u589e\u5931\u8d25");
    }

    @Override
    public ServiceResponse updateDataRule(BoDataRule updateData) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateUpdateDefault(updateData);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        BoDataRule dataRule = (BoDataRule)validateResponse.getData();
        BoDataRuleStructMapper.MAPPER.updateEntity(updateData, dataRule);
        int status = this.boDataRuleMapper.alwaysUpdateSomeColumnById((Object)dataRule);
        return status == 1 ? ServiceResponse.success() : ServiceResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public ServiceResponse removeDataRule(Long appId, Long dataRuleId) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateDefaultExist(appId, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        BoDataRule dataRule = new BoDataRule().setDeleteFlag("0");
        boolean status = this.boDataRuleService.update((Object)dataRule, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoDataRule::getDeleteFlag, (Object)"1")).eq(BoDataRule::getAppId, (Object)appId)).eq(BoDataRule::getId, (Object)dataRuleId));
        return status ? ServiceResponse.success() : ServiceResponse.fail((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public ServiceResponse updateStatus(BoDataRule updateData) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateUpdateDefault(updateData);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        BoDataRule dataRule = (BoDataRule)validateResponse.getData();
        dataRule.setStatus(DataRuleStatus.fromCode((String)updateData.getStatus()).code());
        boolean status = this.boDataRuleService.updateById((Object)dataRule);
        return status ? ServiceResponse.success() : ServiceResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }
}

