/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.datarule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleStatus;
import com.xforceplus.ultraman.bocp.metadata.datarule.service.IDataRuleExService;
import com.xforceplus.ultraman.bocp.metadata.datarule.validator.DataRuleValidator;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DataRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.validator.ValidateResponse;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.DataRuleMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDataRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataRuleExServiceImpl
implements IDataRuleExService {
    @Autowired
    private IDataRuleService dataRuleService;
    @Autowired
    private DataRuleMapper dataRuleMapper;
    @Autowired
    private DataRuleValidator dataRuleValidator;

    @Override
    public ServiceResponse saveDataRule(DataRule dataRule) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCreateCustom(dataRule);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        dataRule.setId(null);
        dataRule.setUniqueId(null);
        dataRule.setVersion("0.0.0");
        dataRule.setStatus(DataRuleStatus.ENABLED.code());
        boolean status = this.dataRuleService.save((Object)dataRule);
        return status ? ServiceResponse.success() : ServiceResponse.fail((String)"\u65b0\u589e\u5931\u8d25");
    }

    @Override
    public ServiceResponse updateDataRule(DataRule updateData) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateUpdateCustom(updateData);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        DataRule dataRule = (DataRule)validateResponse.getData();
        DataRuleStructMapper.MAPPER.updateEntity(updateData, dataRule);
        int status = this.dataRuleMapper.alwaysUpdateSomeColumnById((Object)dataRule);
        return status == 1 ? ServiceResponse.success() : ServiceResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public ServiceResponse removeDataRule(Long appId, Long dataRuleId) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCustomExist(appId, null, dataRuleId);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        DataRule dataRule = new DataRule().setDeleteFlag("0");
        boolean status = this.dataRuleService.update((Object)dataRule, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataRule::getDeleteFlag, (Object)"1")).eq(DataRule::getAppId, (Object)appId)).eq(DataRule::getId, (Object)dataRuleId));
        return status ? ServiceResponse.success() : ServiceResponse.fail((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public ServiceResponse updateTenantScope(DataRule updateData) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateUpdateCustom(updateData);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        DataRule dataRule = (DataRule)validateResponse.getData();
        dataRule.setTenantScope(updateData.getTenantScope());
        int status = this.dataRuleMapper.alwaysUpdateSomeColumnById((Object)dataRule);
        return status == 1 ? ServiceResponse.success() : ServiceResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public ServiceResponse updateStatus(DataRule updateData) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateUpdateCustom(updateData);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        DataRule dataRule = (DataRule)validateResponse.getData();
        dataRule.setStatus(DataRuleStatus.fromCode((String)updateData.getStatus()).code());
        return this.dataRuleService.updateById((Object)dataRule) ? ServiceResponse.success() : ServiceResponse.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }
}

