/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.datarule.validator;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleRowType;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleType;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DefaultDataRuleOp;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.validator.AppValidator;
import com.xforceplus.ultraman.bocp.metadata.validator.DeployEnvValidator;
import com.xforceplus.ultraman.bocp.metadata.validator.ValidateResponse;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDataRuleService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataRuleValidator {
    @Autowired
    private AppValidator appValidator;
    @Autowired
    private DeployEnvValidator deployEnvValidator;
    @Autowired
    private IBoDataRuleService boDataRuleService;
    @Autowired
    private IDataRuleService dataRuleService;
    @Autowired
    private DataRuleRepository dataRuleRepository;

    public ValidateResponse validateCreateDefault(BoDataRule boDataRule) {
        try {
            ValidateResponse validateResponse = this.appValidator.validateExist(boDataRule.getAppId());
            if (validateResponse.failed()) {
                return validateResponse;
            }
            this.validateRowRuleType(boDataRule.getRowRuleType(), boDataRule.getRowField());
            ValidateResponse drValidateResponse = this.validateDefaultNotExist(boDataRule);
            if (drValidateResponse.failed()) {
                return drValidateResponse;
            }
        }
        catch (ValidateException e) {
            return ValidateResponse.failed((String)e.getMessage());
        }
        return ValidateResponse.success();
    }

    public ValidateResponse validateUpdateDefault(BoDataRule boDataRule) {
        try {
            ValidateResponse validateResponse = this.appValidator.validateExist(boDataRule.getAppId());
            if (validateResponse.failed()) {
                return validateResponse;
            }
            return this.validateDefaultExist(boDataRule.getAppId(), boDataRule.getId());
        }
        catch (ValidateException e) {
            return ValidateResponse.failed((String)e.getMessage());
        }
    }

    public ValidateResponse validateDefaultNotExist(BoDataRule dataRule) {
        List boDataRules = this.dataRuleRepository.getDefaultDataRules(dataRule.getAppId(), dataRule.getBoId(), null);
        return boDataRules.isEmpty() ? ValidateResponse.success() : ValidateResponse.failed((String)"\u9ed8\u8ba4\u6570\u636e\u6743\u9650\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
    }

    public ValidateResponse validateDefaultExist(Long appId, Long dataRuleId) {
        BoDataRule dataRule = (BoDataRule)this.boDataRuleService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoDataRule::getDeleteFlag, (Object)"1")).eq(BoDataRule::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(BoDataRule::getAppId, (Object)appId)).eq(BoDataRule::getId, (Object)dataRuleId), false);
        if (dataRule == null) {
            return ValidateResponse.failed((String)"\u67e5\u8be2\u4e0d\u5230\u6570\u636e\u6743\u9650\u89c4\u5219");
        }
        return ValidateResponse.success((Object)dataRule);
    }

    public ValidateResponse validateCreateCustom(DataRule dataRule) {
        try {
            ValidateResponse validateResponse = this.appValidator.validateExist(dataRule.getAppId());
            if (validateResponse.failed()) {
                return validateResponse;
            }
            this.validateType(dataRule.getType());
            this.validateDefaultRuleOp(dataRule.getDefaultRuleOp());
            this.validateRowRuleType(dataRule.getRowRuleType(), dataRule.getRowField());
        }
        catch (ValidateException e) {
            return ValidateResponse.failed((String)e.getMessage());
        }
        return ValidateResponse.success();
    }

    public ValidateResponse validateUpdateCustom(DataRule dataRule) {
        try {
            ValidateResponse validateResponse = this.appValidator.validateExist(dataRule.getAppId());
            if (validateResponse.failed()) {
                return validateResponse;
            }
            return this.validateCustomExist(dataRule.getAppId(), dataRule.getEnvId(), dataRule.getId());
        }
        catch (ValidateException e) {
            return ValidateResponse.failed((String)e.getMessage());
        }
    }

    public ValidateResponse validateCustomExist(Long appId, Long envId, Long dataRuleId) {
        DataRule dataRule;
        LambdaQueryWrapper dataRuleWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataRule::getDeleteFlag, (Object)"1")).eq(DataRule::getAppId, (Object)appId)).eq(DataRule::getId, (Object)dataRuleId);
        ValidateResponse validateResponse = this.deployEnvValidator.validateExist(envId);
        if (validateResponse.isSuccess()) {
            dataRuleWrapper.eq(DataRule::getEnvId, (Object)envId);
        }
        if ((dataRule = (DataRule)this.dataRuleService.getOne((Wrapper)dataRuleWrapper, false)) == null) {
            return ValidateResponse.failed((String)"\u67e5\u8be2\u4e0d\u5230\u6570\u636e\u6743\u9650\u89c4\u5219");
        }
        return ValidateResponse.success((Object)dataRule);
    }

    public void validateDefaultRuleOp(String defaultRuleOp) {
        DefaultDataRuleOp defaultDataRuleOp = DefaultDataRuleOp.fromCode((String)defaultRuleOp);
        if (null == defaultDataRuleOp) {
            throw new ValidateException("\u9ed8\u8ba4\u6570\u636e\u6743\u9650\u89c4\u5219\u5904\u7406\u65b9\u5f0f\u4e0d\u5b58\u5728");
        }
    }

    public void validateType(String type) {
        DataRuleType dataRuleType = DataRuleType.fromCode((String)type);
        if (null == dataRuleType) {
            throw new ValidateException("\u6570\u636e\u6743\u9650\u89c4\u5219\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
    }

    public void validateRowRuleType(String rowRuleType, String rowField) {
        if ((DataRuleRowType.CURRENT_ORG_IDS.code().equals(rowRuleType) || DataRuleRowType.CURRENT_ORG_CODES.code().equals(rowRuleType)) && StringUtils.isEmpty((CharSequence)rowField)) {
            throw new ValidateException(String.format("\u6570\u636e\u8303\u56f4\u3010%s\u3011\u5bf9\u5e94\u5b57\u6bb5\u7f3a\u5931", rowRuleType));
        }
    }
}

